define([
    'backbone',
    'underscore',
    'text!template/index/index.html',
    'swiper'
], function(
    Backbone,
    _us,
    indexTemplate,
    swiper
){
    return function(){

        var map = {
            sport: _('Sport'),
            live: _('Live'),
            casino: _('Casino'),
            register: _('Register'),
            poker: _('Poker'),
            now: _('Now'),
            play: _('Play'),
            sport_bettings: _('Sport Bettings'),
            live_bettings: _('Live Bettings'),
            live_casino: _('Live Casino'),
            bettings: _('Bettings'),
            deposit: _('Deposit'),
            live_casinos: _('Live Casinos'),
            live_support: _('Live Support'),
            in_game: _('In Game'),
            mobile: _('Mobile Betting'),
            time: _('Save Time'),
            prizes: _('Many Prizes'),
            bonuses: _('Bonuses'),
            payment: _('Fast Payment'),
            continued: _('Continued'),
            live_sup: _('Live Support'),
        };

        this.ViewDefault = Backbone.View.extend({
            className:'',
            initialize: function(){
                this.render();
            },
            template: _us.template(indexTemplate),
            render: function(){
                this.$el.html(this.template({
                    map: map
                }));
                App.ModuleManager.wrap();
                return this;
            }
        });
    };
});