function liveMenuTemplate(data) {
    var liveMenuHtml = "";
    var totalCount = 0;
    if (data != null) {
        $.each(data, function (key, sport) {
            liveMenuHtml += sportMenuTemplate(sport);
        });

    }
    return liveMenuHtml;
}

function sportMenuTemplate(sport) {
    var liveMenuHtml = "";
    liveMenuHtml += "<li id=\"lvm-" + sport.stid + "\" class=\"menuc1 open sportm-order-" + sport.o + "\"><a href=\"javascript:void(0)\" onclick=\"liveMenuToggle(this)\" class=\"live-theme" + sport.stid + "\"><span class=\"sportmain\">\n\
                    <i class=\"sporttype" + sport.stid + "\"><\/i><\/span> " + sport.stn + " <span class=\"badge\">0</span><\/a>";
    liveMenuHtml += "   <ul id=\"sportm-ct-" + sport.stid + "\">";
    $.each(sport.cs, function (key, country) {
        liveMenuHtml += countryMenuTemplate(country);
    });
    liveMenuHtml += "   <\/ul>";
    liveMenuHtml += "<\/li>";
    return liveMenuHtml;
}

function countryMenuTemplate(country) {
    var liveMenuHtml = "";
    liveMenuHtml += "	<li id=\"lvm-" + country.stid + "-" + country.cid + "\" class=\"menuc2 active open countrym-order-" + country.o + "\">\n\
                            <a href=\"javascript:void(0)\" onclick=\"liveMenuToggle(this)\"><span class=\"flagmain\"><i class=\"flag" + country.cid + "\"><\/i><\/span> " + country.n + " (<span id=\"countrym-cnt-" + country.stid + "-" + country.cid + "\"></span>)<\/a>";
    liveMenuHtml += "           <ul id=\"countrym-fix-" + country.stid + "-" + country.cid + "\">";
    $.each(country.s, function (key, season) {
        liveMenuHtml += seasonMenuTemplate(season);
    });
    liveMenuHtml += "           <\/ul>";
    liveMenuHtml += "	<\/li>";
    return liveMenuHtml;
}

function seasonMenuTemplate(season) {
    var liveMenuHtml = "";
    $.each(season.f, function (key, fixture) {
        liveMenuHtml += fixtureMenuTemplate(fixture);
    });
    return liveMenuHtml;
}

function fixtureMenuTemplate(fixture) {
    var liveMenuHtml = "";
    liveMenuHtml += "		<li class=\" fix-season-" + fixture.sid + "\" id=\"lvmfix-" + fixture.fid + "\">";
    liveMenuHtml += "			<a href=\"#live/" + fixture.fid + "\" class=\"livemenumatch\" id=\"lmi-" + fixture.fid + "\">";
    liveMenuHtml += "                           <span class=\"livenow-teams\">" + fixture.hcn + " - " + fixture.acn + "<\/span>";
    liveMenuHtml += "                           <span class=\"livenow-scoreinfo\" id=\"fix-spm-" + fixture.fid + "\">";
    liveMenuHtml += menuScorePanelTemplate(fixture.match);
    liveMenuHtml += "                           <\/span>";
    if (fixture.ils) {
        liveMenuHtml += "                           <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
    }
    liveMenuHtml += "			<\/a>";
    liveMenuHtml += "		<\/li>";
    return liveMenuHtml;
}

function menuScorePanelTemplate(match) {
    var liveMenuHtml = "";
    liveMenuHtml += "                           <span class=\"livenow-inscore\">" + smart(match.sc, '') + "<\/span> ";
    liveMenuHtml += "                           <span class=\"livenow-inscore\">" + smart(match.mt, '') + "<\/span> ";
    liveMenuHtml += "                           <span class=\"livenow-inscore\">" + smart(match.st, '') + "<\/span>";

    return liveMenuHtml;
}

function liveOverviewTemplate(data) {
    var overviewHtml = "";
    overviewHtml = liveOverviewFilterTemplate(data);
    $.each(data, function (key, sport) {
        overviewHtml += sportTemplate(sport);
    });

    return overviewHtml;
}

function liveOverviewFilterTemplate(data) {
    var html = "";
    html += "<div class=\"live-filter\">";
    html += "    <ul class=\"live-filter-nav\">";
    html += "        <li><a onclick=\"overviewFilterSport(0,this)\" class=\"live-filter-a active\"><span class=\"glyphicon glyphicon-th\" aria-hidden=\"true\"><\/span> " + $('#lbl_all').text() + " <span class=\"badge-live\" id=\"filter-badge-all\">0</span><\/a><\/li>";
    $.each(data, function (key, sport) {
        html += "       <li><a onclick=\"overviewFilterSport(" + sport.stid + ",this)\" class=\"live-filter-a\"><span class=\"sportmain\"><i class=\"sporttype" + sport.stid + "\"><\/i><\/span> " + sport.stn + " <span class=\"badge-live\" id=\"filter-badge-" + sport.stid + "\">0</span><\/a><\/li>";
    });
    html += "     <\/ul>";
    html += "<\/div>";
    return html;
}

function sportTemplate(sport) {
    var overviewHtml = "";
    overviewHtml += "	<div class=\"wrap-overview-main live-theme" + sport.stid + " sport-order-" + sport.o + "\" id=\"sport-" + sport.stid + "\">\n\
                        <div class=\"live-overview-title\" data-toggle=\"collapse\" data-target=\"#ac-kapa-fixovers-" + sport.stid + "\">";
    overviewHtml += "		<span class=\"sportmain\"><i class=\"sporttype" + sport.stid + "\"><\/i><\/span>";
    overviewHtml += "		<strong>" + sport.stn + "<\/strong>";
    overviewHtml += "	<\/div>";
    overviewHtml += "	<div class=\"close-open in\" id=\"ac-kapa-fixovers-" + sport.stid + "\">";
    $.each(sport.cs, function (key, country) {
        overviewHtml += countryTemplate(country);
    });
    overviewHtml += "<\/div>";
    overviewHtml += "<\/div>";
    return overviewHtml;
}


function countryTemplate(data) {
    var overviewHtml = "";
    overviewHtml += "<div class=\"live-overview-country-wrap country-order-" + data.o + "\" id=\"country-" + data.stid + "-" + data.cid + "\">";
    $.each(data.s, function (key, season) {
        overviewHtml += seasonTemplate(season);
    });
    overviewHtml += "</div>";
    return overviewHtml;
}


function seasonTemplate(season) {
    var overviewHtml = "";
    overviewHtml += "	<div class=\"live-overview-sub-wrap season-order-" + season.o + "\" id=\"season-" + season.sid + "\">";
    overviewHtml += "		<div class=\"live-league-title bordertop\" data-toggle=\"collapse\" data-target=\"#ac-kapa-fixover-" + season.sid + "\">";
    overviewHtml += "			<span class=\"flagmain\"><i class=\"flag" + season.cid + "\"><\/i><\/span> ";
    overviewHtml += "			" + season.cn + " " + season.sname + "";
    overviewHtml += "		<\/div> ";
    overviewHtml += "		<div class=\"close-open in\" id=\"ac-kapa-fixover-" + season.sid + "\"> ";
    overviewHtml += "		<ul class=\"live-overview-sub-content\" id=\"fixturelist-" + season.sid + "\">";
    $.each(season.f, function (key, fixture) {
        overviewHtml += fixtureTemplate(fixture);
    });
    overviewHtml += "		<\/ul>";
    overviewHtml += "		<\/div> ";
    overviewHtml += "	<\/div>";
    return overviewHtml;

}

function fixtureTemplate(fixture) {
    var overviewHtml = "";
    var isValid = fixture.valid ? 'analive' : 'anadisabled';
    overviewHtml += "			<li id=\"fixture-" + fixture.fid + "\">";
    overviewHtml += "				<div class=\"live-overview-events\">";
    overviewHtml += "					<div id=\"score-panel-" + fixture.fid + "\">";
    overviewHtml += scorePanel(fixture.stid, fixture);
    overviewHtml += "					<\/div>";
    overviewHtml += "				<\/div>";
    overviewHtml += "                           <div id=\"change-btg-" + fixture.fid + "\">";
    overviewHtml += overviewBetTypeGroupTemplate(fixture.btgs[0], isValid);
    overviewHtml += "                           </div>";
    overviewHtml += "				<div class=\"live-overview-subrates\">";
    overviewHtml += "					<span class=\"live-overview-others-title\">" + $('#lbl_all').text() + "<\/span>";
    overviewHtml += "					<span style=\"display:block;\"><a href=\"#live/" + fixture.fid + "\" class=\"live-others-button\">+" + fixture.oc + "<\/a><\/span>";
    overviewHtml += "				<\/div>";
    overviewHtml += "			<\/li>";
    return overviewHtml;
}

function overviewBetTypeGroupTemplate(data, isValid) {
    var overviewHtml = "";
    overviewHtml += "				<div class=\"live-overview-rates\">";
    overviewHtml += "					<span class=\"live-overview-rate-title\">" + data.odds[0].btname + "<\/span>";
    overviewHtml += "					<span style=\"display:block;\">";
    overviewHtml += "						<div class=\"btn-group btn-group-justified\">";
    if (typeof data.odds[0].ho != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 1) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + data.odds[0].foid + ",1,'l')" : "return false; coupon(" + data.odds[0].foid + ",1,'l')";
        overviewHtml += "							<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + data.fid + "\" title=\"" + data.odds[0].hs + "\" id=\"a" + data.odds[0].foid + "1\">";
        overviewHtml += "								<div class=\"button-wrap\">";
        overviewHtml += "									<span class=\"main-team-live\">" + data.odds[0].hs + "<\/span>";
        overviewHtml += "									<span class=\"rate-change\" id=\"oddchn-" + data.odds[0].foid + "1\"><\/span>";
        overviewHtml += "									<span class=\"main-rate-live\" id=\"newodd-" + data.odds[0].foid + "1\">" + data.odds[0].ho.toFixed(2) + "<\/span>";
        overviewHtml += "								<\/div>    ";
        overviewHtml += "							<\/a>";
    }
    if (typeof data.odds[0].do != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 0) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + data.odds[0].foid + ",0,'l')" : "return false; coupon(" + data.odds[0].foid + ",0,'l')";
        overviewHtml += "							<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + data.fid + "\" title=\"" + data.odds[0].ds + "\" id=\"a" + data.odds[0].foid + "0\">";
        overviewHtml += "								<div class=\"button-wrap\">";
        overviewHtml += "									<span class=\"main-team-live\">" + data.odds[0].ds + "<\/span>";
        overviewHtml += "									<span class=\"rate-change\" id=\"oddchn-" + data.odds[0].foid + "0\"><\/span>";
        overviewHtml += "									<span class=\"main-rate-live\" id=\"newodd-" + data.odds[0].foid + "0\">" + data.odds[0].do.toFixed(2) + "<\/span>";
        overviewHtml += "								<\/div>    ";
        overviewHtml += "							<\/a>";
    }
    if (typeof data.odds[0].ao != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 2) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + data.odds[0].foid + ",2,'l')" : "return false; coupon(" + data.odds[0].foid + ",2,'l')";
        overviewHtml += "							<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + data.fid + "\" title=\"" + data.odds[0].as + "\" id=\"a" + data.odds[0].foid + "2\">";
        overviewHtml += "								<div class=\"button-wrap\">";
        overviewHtml += "									<span class=\"main-team-live\">" + data.odds[0].as + "<\/span>";
        overviewHtml += "									<span class=\"rate-change\" id=\"oddchn-" + data.odds[0].foid + "2\"><\/span>";
        overviewHtml += "									<span class=\"main-rate-live\" id=\"newodd-" + data.odds[0].foid + "2\">" + data.odds[0].ao.toFixed(2) + "<\/span>";
        overviewHtml += "								<\/div>    ";
        overviewHtml += "							<\/a>";
    }

    overviewHtml += "						<\/div>";
    overviewHtml += "					<\/span>";
    overviewHtml += "				<\/div>";

    return overviewHtml;
}





//<editor-fold defaultstate="collapsed" desc="Score Panel">
function scorePanel(sportTypeId, fixture) {
    var panelHtml = "";
    var score = smart(fixture.match.sc, '-:-').split(':');
    panelHtml += "<a href=\"#live/" + fixture.fid + "\">";
    if (sportTypeId == 1) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-scoretitle\">Skor<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\"><span class=\"live-yellow\"><\/span><\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\"><span class=\"live-red\"><\/span><\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\"><span class=\"live-corner\"><\/span><\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.ych, '-') + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.rch, '-') + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.ch, '-') + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.yca, '-') + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.rca, '-') + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.ca, '-') + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";
    } else if (sportTypeId == 2 || sportTypeId == 3) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">Skor<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">1.Ç<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">2.Ç<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">3.Ç<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">4.Ç<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + score[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc3, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc4, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + score[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc3, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc4, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 4 || sportTypeId == 9 || sportTypeId == 10) {
        var setnow = fixture.match.st.substring(0, 1);
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 1 ? 'now' : '') + "\">1. Ç<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 2 ? 'now' : '') + "\">2. Ç<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 3 ? 'now' : '') + "\">3. Ç<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 1 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 2 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 3 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc3, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 1 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 2 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 3 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc3, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 5) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">1. Yarı<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">2. Yarı<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 6) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "<tr>";
        panelHtml += "	<td class=\"live-overview-teamtitle\"><b>Sonuç<\/b><\/td>";
        panelHtml += "	<td class=\"live-overview-intitlenow\">1<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">2<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">3<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">4<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">5<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">6<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">7<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">8<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">9<\/td>";
        panelHtml += "<\/tr>";
        panelHtml += "<tr>";
        panelHtml += "	<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc3, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc4, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc5, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc6, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc7, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc8, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc9, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "<\/tr>";
        panelHtml += "<tr>";
        panelHtml += "	<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc3, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc4, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc5, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc6, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc7, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc8, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<td class=\"live-overview-intitle\">" + smart(fixture.match.sc9, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 28) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">Skor<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">1 Yarı<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">2 Yarı<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 36 || sportTypeId == 35) {
        var setnow = fixture.match.st.substring(0, 1);
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-service\"><\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">Skor<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">" + $('#lbl_game').text() + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 1 ? 'now' : '') + "\">1.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 2 ? 'now' : '') + "\">2.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 3 ? 'now' : '') + "\">3.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 4 ? 'now' : '') + "\">4.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle" + (setnow == 5 ? 'now' : '') + "\">5.Set<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-service\">";
        if (smart(fixture.match.server, '0') == '1') {
            panelHtml += "          <span class=\"live-tenis-service\"><\/span>";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + score[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.gamescore, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 1 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 2 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 3 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc3, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 4 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc4, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 5 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc5, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-service\">";
        if (smart(fixture.match.server, '0') == '2') {
            panelHtml += "          <span class=\"live-tenis-service\"><\/span>";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + score[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.gamescore, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 1 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 2 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 3 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc3, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 4 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc4, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-" + (setnow == 5 ? 'intitlenow' : 'incontent') + "\">" + smart(fixture.match.sc5, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 37) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">1. Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">2.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">3. Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">4.Set<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">5.Set<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc3, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc4, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc5, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc3, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc4, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc5, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 23 || sportTypeId == 28) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>" + fixture.match.st + " - " + smart(fixture.match.mt, '') + "<\/b>";
        if (fixture.ils) {
            panelHtml += "             <span class=\"glyphicon glyphicon-facetime-video font12 live-video-icon\" aria-hidden=\"true\">";
        }
        panelHtml += "          <\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">Skor<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">1 Yarı<\/td>";
        panelHtml += "		<td class=\"live-overview-intitle\">2 Yarı<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc1, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc1, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "		<td class=\"live-overview-incontent\">" + smart(fixture.match.sc2, '-:-').split(':')[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";

    } else if (sportTypeId == 20 || sportTypeId == 16 || sportTypeId == 29) {
        panelHtml += "<table class=\"live-overview-teamname\">";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-teamtitle\"><b>-<\/b><\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">Skor<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-hometeam\" title=\"" + fixture.hcn + "\">" + fixture.hcn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[0] + "<\/td>";
        panelHtml += "	<\/tr>";
        panelHtml += "	<tr>";
        panelHtml += "		<td class=\"live-overview-awayteam\" title=\"" + fixture.acn + "\">" + fixture.acn + "<\/td>";
        panelHtml += "		<td class=\"live-overview-intitlenow\">" + score[1] + "<\/td>";
        panelHtml += "	<\/tr> ";
        panelHtml += "<\/table>";
    }
    panelHtml += "</a>";
    return panelHtml;
}
//</editor-fold>


function addBetRadarWidgetsWithNewId(matchId) {
    var widgets = {
        lmts: function () {
            var lmtsOptions = {
                matchId: matchId,
                container: '.lmt-container',
                showMomentum: false
            };
            SRLive.addWidget('widgets.lmts', lmtsOptions);
        }(),
        matchcommentary: function () {
            var matchCommentarOptions = {
                container: '.lmt-widgets-matchcommentary',
                height: '300',
                showTitle: true,
                matchId: matchId,
                showGoals: true,
                showAssists: true,
                showCards: true
            };
            SRLive.addWidget('widgets.matchcommentary', matchCommentarOptions);
        }(),
        livetable: function () {
            var livetableOptions = {
                container: '.lmt-widgets-livetable',
                height: '300',
                showTitle: true,
                matchId: matchId,
                promotionLegend: true,
                enableFeedPolling: true,
                tournamentId: null,
                seasonId: null,
                respondToSetMatchFocus: true
            };
            SRLive.addWidget('widgets.livetable', livetableOptions);
        }(),
        matchhead2head: function () {
            var matchhead2headOptions = {
                container: '.lmt-widgets-matchhead2head',
                height: '300',
                showTitle: true,
                matchId: matchId
            };
            SRLive.addWidget('widgets.matchhead2head', matchhead2headOptions);
        }(),
        matchlineups: function () {
            var matchlineupsOptions = {
                container: '.lmt-widgets-matchlineups',
                height: '300',
                showTitle: true,
                matchId: matchId
            };
            SRLive.addWidget('widgets.matchlineups', matchlineupsOptions);
        }(),
        matchstats: function () {
            var matchstatsOptions = {
                container: '.lmt-widgets-matchstats',
                height: '300',
                showTitle: true,
                matchId: matchId
            };
            SRLive.addWidget('widgets.matchstats', matchstatsOptions);
        }(),
        toplists: function () {
            var toplistsOptions = {
                container: '.lmt-widgets-toplists',
                height: '300',
                showTitle: true,
                matchId: matchId,
                showGoals: true,
                showAssists: true,
                showCards: true
            };
            SRLive.addWidget('widgets.toplists', toplistsOptions);
        }()
    };
}

function loadBetradarScript(matchId, lang, timezone) {
    var lang = lang ? lang : "tr";
    var timezone = timezone ? timezone : "Europe:Istanbul";
    
    var tabContent = $('.tab-content');
    if(tabContent){
       tabContent.find('.tab-pane').removeClass('active');
    }
    
    
    $.getScript("https://cs.betradar.com/ls/widgets/?/universalsoftwaresolutions/tr/widgetloader/widgets", function (data, textStatus, jqxhr) {
        //console.log('sakir abiiii ',SRLive);
        addBetRadarWidgetsWithNewId(matchId);
    });
}



function liveFixtureTemplate(fixture) {



    if (fixture.match.bs == 'ended') {
        window.location.replace(pronetTradDom + "live/");
    }
    if (!livescoreopen && $('#livescoreboard').length > 0) {
        $.get(pronetTradDom + 'ajax/getlivescoreurl/' + fixture.stid + '/', function (data) {
            if (data != '') {
                loadBetradarScript(fixture.match.mid, 'se', 'Europe:Berlin');

                $('#livescoreboard').removeClass().addClass('livescoreboard livescoreboard' + fixture.stid);
                $('#livescoreboard').show();
                $('.live-event-league').html("<span class=\"flagmain\"><i class=\"flag" + fixture.cid + " margin0\"></i></span> " + fixture.cn + " " + fixture.sn + "");
                $('.live-event-hometeam').text(fixture.hcn);
                $('.live-event-scorenow').text(fixture.match.sc);
                $('.live-event-awayteam').text(fixture.acn);
                $('.live-event-start').html('<span class="glyphicon glyphicon-time"></span>  ' + (fixture.fsds));

                data = data.replace('{matchid}', fixture.match.mid);
                $('#livescoreframe').attr('src', data);
                $('#livescoreframe').show();
                $('#livescoreframe').css("height", "");
                $('#livescoreframe').removeClass().addClass('livescoreframe' + fixture.stid);
            }
            livescoreopen = true;
        });
    }
    //Video Stream
    if (fixture.ils) {
        $('.livescoreboard-headwrap').show();
    } else {
        $('.livescoreboard-headwrap').hide();
    }
    //
    var fixtureHtml = "";
    var odds = new Object();
    var score = smart(fixture.match.sc, '-:-').split(':');
    var isValid = fixture.valid ? 'analive' : 'anadisabled';
    if ($('#livescoreboard').length < 1) {
        fixtureHtml += "<div class=\"live-event-wrap live-theme" + fixture.stid + "\">";
        fixtureHtml += "	<div class=\"live-event-inside\">";
        fixtureHtml += "		<div class=\"live-event-title\">";
        fixtureHtml += "			<span class=\"live-event-league\"><span class=\"flagmain\"><i class=\"flag" + fixture.cid + " margin0\"><\/i><\/span> " + fixture.cn + " " + fixture.sn + "<\/span>";
        fixtureHtml += "			<span class=\"live-event-hometeam\">" + fixture.hcn + "<\/span>";
        fixtureHtml += "			<span class=\"live-event-scorenow\">" + fixture.match.sc + "<\/span>";
        fixtureHtml += "			<span class=\"live-event-awayteam\">" + fixture.acn + "<\/span>";
        fixtureHtml += "			<span class=\"live-event-start\"><span class=\"glyphicon glyphicon-time\"><\/span> " + (fixture.fsds) + "<\/span>";
        fixtureHtml += "		<\/div>";
        fixtureHtml += "		<div class=\"live-event-content\">";
        fixtureHtml += "			<div class=\"live-event-content-wrap\">";
        fixtureHtml += "            <div class=\"livebig\" id=\"score-panel-" + fixture.fid + "\">";
        fixtureHtml += scorePanel(fixture.stid, fixture);
        fixtureHtml += "            </div>";
        fixtureHtml += "				<div class=\"live-event-status\" style=\"display:none\"><span class=\"glyphicon glyphicon-play font12\"><\/span> " + smart(fixture.match.st, '') + "<\/div>";
        fixtureHtml += "			<\/div>";
        fixtureHtml += "		<\/div>";
        fixtureHtml += "	<\/div>";
        fixtureHtml += "	<span class=\"sporticon" + fixture.stid + "\"><\/span>";
        fixtureHtml += "<\/div>";
    } else {
        $('#livescoreboard').removeClass().addClass('livescoreboard livescoreboard' + fixture.stid);
        $('#livescoreboard').show();
        $('.live-event-league').html("<span class=\"flagmain\"><i class=\"flag" + fixture.cid + " margin0\"></i></span> " + fixture.cn + " " + fixture.sn + "");
        $('.live-event-hometeam').text(fixture.hcn);
        $('.live-event-scorenow').text(fixture.match.sc);
        $('.live-event-awayteam').text(fixture.acn);
        $('.live-event-start').html('<span class="glyphicon glyphicon-time"></span>  ' + fixture.dsds);
    }
    fixtureHtml += "<div class=\"live-event-rate-well\">";
    fixtureHtml += "	<div class=\"live-event-actions-title\">";
    fixtureHtml += "		<div class=\"pull-left\">";
    fixtureHtml += "			<div class=\"live-events-actions-column\">";
    fixtureHtml += "				<ul>";

   fixtureHtml += "                 <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Maç Bahisleri<\/a><\/li>";
   fixtureHtml += "                  <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Gol Bahisleri <\/a><\/li>";
   fixtureHtml += "                   <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Handikap Bahisleri <\/a><\/li>";
   fixtureHtml += "                   <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Korner Bahisleri <\/a><\/li>"; 
   fixtureHtml += "                   <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Kart Bahisleri <\/a><\/li>";
   fixtureHtml += "                   <li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> Golcü Bahisleri <\/a><\/li>";   

    fixtureHtml += "					<li><a onclick=\"openAllFixture()\"><span class=\"glyphicon glyphicon-chevron-down\"><\/span> " + $('#lbl_expand').text() + "<\/a><\/li>";
    fixtureHtml += "					<li><a onclick=\"closeAllFixture()\"><span class=\"glyphicon glyphicon-chevron-up\"><\/span> " + $('#lbl_collapse').text() + "<\/a><\/li>";
    //fixtureHtml += "					<li><a class=\"selected\"><span class=\"glyphicon glyphicon-align-justify\"><\/span> Tek Kolonda Göster<\/a><\/li>";
    // fixtureHtml += "					<li><a><span class=\"glyphicon glyphicon-th-large\"><\/span> İki Kolonda Göster<\/a><\/li>";
    fixtureHtml += "				<\/ul>";
 
    fixtureHtml += "			<\/div>";
    fixtureHtml += "		<\/div>";
    fixtureHtml += "		<div class=\"pull-right\">";
    fixtureHtml += "			<div class=\"dropdown live-event-bettype-group\">";
    fixtureHtml += "				<a class=\"dropdown-toggle\" id=\"dropdownMenu1\" data-toggle=\"dropdown\">" + (betTypeGroupMenuName == null ? $('#lbl_betgroup').text() : betTypeGroupMenuName) + " <span class=\"caret\"><\/span><\/a>";
    fixtureHtml += "				<ul class=\"dropdown-menu pull-right\" role=\"menu\" aria-labelledby=\"dropdownMenu1\">";
    fixtureHtml += "					<li><a role=\"menuitem\" tabindex=\"-1\" onclick=\"getBetTypeGroupMarketOdds(0,'" + $('#lbl_betgroupall').text() + "')\">" + $('#lbl_betgroupall').text() + "<\/a><\/li>";
    fixtureHtml += getBetTypeGroupMarketMenu(fixture.stid);
    fixtureHtml += "				<\/ul>";
    fixtureHtml += "			<\/div>";
    fixtureHtml += "		<\/div>   ";
    fixtureHtml += "	<\/div>";
    fixtureHtml += "	<div class=\"live-event-bettype-title\">";
    fixtureHtml += "		<span class=\"pull-left\">" + betTypeGroupMenuName + "<\/span>";
    fixtureHtml += "		<span class=\"pull-right\"><a class=\"close-icon-sm clsoe-white\" onclick=\"closeGroupMarketLine()\"><\/a><\/span>";
    fixtureHtml += "	<\/div>";
    fixtureHtml += "";
    fixtureHtml += "	<div class=\"double-view\">";
    $.each(fixture.btgs, function (key, btg) {
        fixtureHtml += fixtureBetTypeGroupTemplate(btg, fixture.valid);
    });
    fixtureHtml += "	<\/div>";
    fixtureHtml += "<\/div>    ";



    return fixtureHtml;
}


function fixtureBetTypeGroupTemplate(btg, valid) {
    var fixtureHtml = "";
    var betTypeGroupMarketId = (btg.btgmid == null) ? 0 : btg.btgmid;
    fixtureHtml += "		<div class=\"sub-main-well-live btg-order-" + btg.o + "\" data-groupmarket=\"" + betTypeGroupMarketId + "\" id=\"fx-btg-" + btg.btgid + "\"> \n";
    fixtureHtml += "			<div class=\"sub-rate-title\" data-toggle=\"collapse\" data-target=\"#ac-kapa-sub-rate-" + btg.btgid + "\"> \n";
    fixtureHtml += "				<span>" + btg.btgname + "<\/span> \n";
    fixtureHtml += "			<\/div> \n";
    fixtureHtml += "			<div class=\"close-open in\" id=\"ac-kapa-sub-rate-" + btg.btgid + "\"> \n";
    fixtureHtml += "				<div class=\"sub-fixturelayout\"> \n";
    fixtureHtml += "					<ul> \n";
    fixtureHtml += "						<li> \n";
    fixtureHtml += "							<div class=\"fixturelayout-rate\"> \n";
    fixtureHtml += "								<ul> \n";
    fixtureHtml += "									<li id=\"btg-odd-" + btg.btgid + "\"> \n";
    $.each(btg.odds, function (key, fixtureOdd) {
        fixtureHtml += fixtureOddTemplate(fixtureOdd, valid);
    });
    fixtureHtml += "									<\/li> \n";
    fixtureHtml += "								<\/ul> \n";
    fixtureHtml += "							<\/div> \n";
    fixtureHtml += "						<\/li> \n";
    fixtureHtml += "					<\/ul> \n";
    fixtureHtml += "				<\/div> \n";
    fixtureHtml += "			<\/div>    \n";
    fixtureHtml += "		<\/div> \n";

    return fixtureHtml;
}



function fixtureOddTemplate(fixtureOdd, valid) {
    var isValid = valid ? 'analive' : 'anadisabled';
    var fixtureHtml = "";
    if (typeof fixtureOdd.do == 'undefined' && typeof fixtureOdd.ao == 'undefined') {
        fixtureHtml += "<div id=\"aa"+fixtureOdd.foid+"\" class=\"btn-group col-md-4 pad0 odd-order-" + fixtureOdd.btgid + "-" + fixtureOdd.oho + "\">\n";
    } else {
        fixtureHtml += "<div id=\"aa"+fixtureOdd.foid+"\" class=\"btn-group btn-group-justified odd-order-" + fixtureOdd.btgid + "-" + fixtureOdd.oho + "\">\n";
    }
    if (typeof fixtureOdd.ho != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 1) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + fixtureOdd.foid + ",1,'l')" : "return false; coupon(" + fixtureOdd.foid + ",1,'l')";
        fixtureHtml += "								<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + curfixtureId + "\" title=\"" + fixtureOdd.hs + "\" id=\"aa" + fixtureOdd.foid + "1\">\n";
        fixtureHtml += "									<div class=\"button-wrap\">\n";
        fixtureHtml += "										<span class=\"main-team-live\">" + fixtureOdd.hs + "<\/span>\n";
        fixtureHtml += "                                                                            <span class=\"rate-change\" id=\"oddchn-" + fixtureOdd.foid + "1\"><\/span>\n";
        fixtureHtml += "										<span class=\"main-rate-live\" id=\"newodd-" + fixtureOdd.foid + "1\">" + fixtureOdd.ho.toFixed(2) + "<\/span>\n";
        fixtureHtml += "									<\/div>    \n";
        fixtureHtml += "								<\/a>\n";
    }
    if (typeof fixtureOdd.do != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 0) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + fixtureOdd.foid + ",0,'l')" : "return false; coupon(" + fixtureOdd.foid + ",0,'l')";
        fixtureHtml += "								<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + curfixtureId + "\" title=\"" + fixtureOdd.ds + "\" id=\"aa" + fixtureOdd.foid + "0\"> \n";
        fixtureHtml += "									<div class=\"button-wrap\"> \n";
        fixtureHtml += "										<span class=\"main-team-live\">" + fixtureOdd.ds + "<\/span> \n";
        fixtureHtml += "                                                                            <span class=\"rate-change\" id=\"oddchn-" + fixtureOdd.foid + "0\"><\/span> \n";
        fixtureHtml += "										<span class=\"main-rate-live\" id=\"newodd-" + fixtureOdd.foid + "0\">" + fixtureOdd.do.toFixed(2) + "<\/span> \n";
        fixtureHtml += "									<\/div>    \n";
        fixtureHtml += "								<\/a> \n";
    }
    if (typeof fixtureOdd.ao != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 2) ? 'anaselected' : '');
        var couponclick = (isValid == 'analive') ? "coupon(" + fixtureOdd.foid + ",2,'l')" : "return false; coupon(" + fixtureOdd.foid + ",2,'l')";
        fixtureHtml += "								<a onclick=\"" + couponclick + "\" class=\"btn " + isValid + " " + selClass + " valid-change-" + curfixtureId + "\" title=\"" + fixtureOdd.as + "\" id=\"aa" + fixtureOdd.foid + "2\"> \n";
        fixtureHtml += "									<div class=\"button-wrap\"> \n";
        fixtureHtml += "										<span class=\"main-team-live\">" + fixtureOdd.as + "<\/span> \n";
        fixtureHtml += "                                                                            <span class=\"rate-change\" id=\"oddchn-" + fixtureOdd.foid + "2\"><\/span> \n";
        fixtureHtml += "										<span class=\"main-rate-live\" id=\"newodd-" + fixtureOdd.foid + "2\">" + fixtureOdd.ao.toFixed(2) + "<\/span> \n";
        fixtureHtml += "									<\/div>    \n";
        fixtureHtml += "								<\/a> \n";
    }
    fixtureHtml += "</div> \n";
    return fixtureHtml;
}