function liveMenuTemplate(data) {
    var totalCount = 0;
    var liveMenuHtml = '<div class="top-live-bar">\
        <div id="wrapper1">\
            <div id="scroller">\
                <ul id="live_menu_list" class="top-icons">';
    if (data != null) {
        $.each(data, function (key, sport) {
            liveMenuHtml += sportMenuTemplate(sport);
        });
    }
    liveMenuHtml += '<li id="live_menu_sportcalendar" data-sport="calendar">\
                        <a id="change_live_season_btncalendar" class="'+($.address.parameter('ls') == 'calendar' ? 'active' : '')+'" href="?ls=calendar">\
                            <div class="block-center"><i class="fa fa-calendar title-text"></i></div>\
                            <div class="block-center">Takvim</div>\
                        </a>\
                    </li>';
    liveMenuHtml += '</ul>\
            </div>\
        </div>\
    </div>';
    return liveMenuHtml;
}
function sportMenuTemplate(sport) {
    var stid = smart($.address.parameter('ls'), websocketData[0].stid);
    var active = (sport.stid == stid) ? ('class="active"') : ('');
    var liveMenuHtml = '<li id="live_menu_sport' + sport.stid + '" class="live-menu-sport" data-sport="' + sport.stid + '" data-order="' + sport.o + '">\
        <a id="change_live_season_btn' + sport.stid + '" href="?ls='+sport.stid+'" '+active+'>\
            <div class="block-center"><span class="sportmain"><i class="sporttype' + sport.stid + '"></i></span></div>\
            <div class="block-center">' + sport.stn + '</div>\
        </a>\
    </li>';
    return liveMenuHtml;
}
function liveOverviewTemplate(data) {
    var overviewHtml = '';
    overviewHtml += '<div data-page="live_overview" class="row">\
        <div class="header-title" style="display:none;">\
            <a class="left-button nav-back-btn"><span class="glyphicon glyphicon-chevron-left"></span></a>\
            <div class="inscroll">\
                <div id="wrapper">\
                    <div id="scroller">\
                        <ul class="list-inline pad0 margin0">\
                            <li>\
                                <span class="sportmain">Canlı Bahisler</span>\
                            </li>\
                        </ul>\
                    </div>\
                </div>\
            </div>\
        </div>\
    </div>\
    <div id="live_menu_grid" class="row">';
    overviewHtml += liveMenuTemplate(data);
    overviewHtml += '</div>\
    <div class="row">\
        <div class="live-title">\
            <span id="live_sport_name" style="display:none"></span>\
            <span id="live_match_count" style="display:none" class="badge f300"></span>\
            <span id="live_calendar_date" style="display:none"><span id="live_calendar_month"></span> - <span id="live_calendar_day"></span></span>\
        </div>\
    </div>\
    <div id="live_overview_grid" class="row pad-sm">';
    if (data.length == 0) {
        overviewHtml += '<div class="main-notification-alert animated fadeInDown fail-alert">\
                <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>\
                <span class="message">Hiç canlı maç bulunmuyor</span>\
            </div>';
    }
    $.each(data, function (key, sport) {
        overviewHtml += sportTemplate(sport);
    });
    overviewHtml += '</div>\
    <div id="live_calendar_grid" class="row" style="display:none">\
    </div>';
    return overviewHtml;
}
function sportTemplate(sport) {
    var stid = smart($.address.parameter('ls'), websocketData[0].stid);
    var display = (sport.stid == stid) ? ('block') : ('none');
    var overviewHtml = '';
    overviewHtml += '<div id="live_sport' + sport.stid + '" style="display:' + display + '" data-sport-name="' + sport.stn + '" data-order="' + sport.o + '" class="live-sport">';
    $.each(sport.cs, function (key, country) {
        overviewHtml += countryTemplate(country);
    });
    overviewHtml += '</div>';
    return overviewHtml;
}
function countryTemplate(country) {
    var overviewHtml = '';
    overviewHtml += '<div id="live_country' + country.stid + '_' + country.cid + '" class="live-country">';
    $.each(country.s, function (key, season) {
        overviewHtml += seasonTemplate(season);
    });
    overviewHtml += '</div>';
    return overviewHtml;
}
function seasonTemplate(season) {
    var overviewHtml = '<div id="live_season' + season.sid + '" class="fixture-grid live-season" data-sport="' + season.stid + '" data-country="' + season.cid + '" data-order="' + season.o + '">\
        <div class="panel">\
            <div class="panel-heading bet-main-title pointer" data-toggle="collapse" data-target="#live_fixture_list' + season.sid + '">\
                <span class="flagmain"><i class="flag' + season.cid + '"></i></span>\
                <span class="bet-main-title-in">' + season.cn + ' ' + season.sname + '</span>\
            </div>\
            <div id="live_fixture_list' + season.sid + '" class="collapse in">';
    $.each(season.f, function (key, fixture) {
        overviewHtml += fixtureTemplate(fixture);
    });
    overviewHtml += '</div>\
        </div>\
    </div>';
    return overviewHtml;
}
function fixtureTemplate(fixture) {
    var isValid = fixture.valid ? 'anaoran' : 'anadisabled';
    var overviewHtml = '<div id="live_fixture' + fixture.fid + '" class="fixture-sporttype live-fixture">\
        <div>\
            <div class="competitors">\
                <a href="#mobile/live_details/' + fixture.fid + '">\
                    <div class="fixture-title">\
                        <div class="competitors-name">' + fixture.hcn + ' - ' + fixture.acn + '</div>\
                            <div id="live_score_panel' + fixture.fid + '" class="live-event-details">';
    overviewHtml += scorePanel(fixture.stid, fixture);
    overviewHtml += '</div>\
                        </div>\
                    <div class="fixture-others">+' + fixture.oc + ' <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span></div>\
                </a>\
            </div>\
            <div class="ratesgrid">\
                <div class="btn-group btn-group-justified btn-group-sm">\
                    <div class="ratesgrid cell" style="display:inline">\
                        <div id="live_bet_type_group' + fixture.fid + '" class="btn-group btn-group-justified btn-group-sm">';
    overviewHtml += overviewBetTypeGroupTemplate(fixture.btgs[0], isValid);
    overviewHtml += '</div>\
                    </div>\
                </div>\
            </div>\
        </div>\
    </div>';
    return overviewHtml;
}
function scorePanel(sportTypeId, fixture) {
    var overviewHtml = '';
    if (sportTypeId == 1) {
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score-current">' + getLiveScore(fixture.match.sc, '-') + '</span>';
    } else if (sportTypeId == 2 || sportTypeId == 3) {
        var setnow = fixture.match.st.substring(0, 1);
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score">' + getLiveScore(fixture.match.sc, '-') + '</span>\
            <span class="live-score' + (setnow == 1 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc1, '-') + '</span>\
            <span class="live-score' + (setnow == 2 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc2, '-') + '</span>\
            <span class="live-score' + (setnow == 3 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc3, '-') + '</span>\
            <span class="live-score' + (setnow == 4 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc4, '-') + '</span>';
    } else if (sportTypeId == 4 || sportTypeId == 9 || sportTypeId == 10) {
        var setnow = fixture.match.st.substring(0, 1);
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score' + (setnow == 1 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc1, '-') + '</span>\
            <span class="live-score' + (setnow == 2 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc2, '-') + '</span>\
            <span class="live-score' + (setnow == 3 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc3, '-') + '</span>';
    } else if (sportTypeId == 5) {
        var setnow = fixture.match.st.substring(0, 1);
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score' + (setnow == 1 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc1, '-') + '</span>\
            <span class="live-score' + (setnow == 2 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc2, '-') + '</span>';
    } else if (sportTypeId == 6) {
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">' + getLiveScore(fixture.match.sc, '-') + '</span>';
    } else if (sportTypeId == 28) {
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">(1-1)</span>\
            <span class="live-score">' + getLiveScore(fixture.match.sc, '-') + '</span>';
    } else if (sportTypeId == 35 || sportTypeId == 36) {
        var setnow = fixture.match.st.substring(0, 1);
        overviewHtml += '<span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score">' + getLiveScore(fixture.match.sc, '-') + '</span>\
            <span class="live-score">' + getLiveScore(fixture.match.gamescore, '-') + '</span>\
            <span class="live-score' + (setnow == 1 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc1, '-') + '</span>\
            <span class="live-score' + (setnow == 2 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc2, '-') + '</span>\
            <span class="live-score' + (setnow == 3 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc3, '-') + '</span>\
            <span class="live-score' + (setnow == 4 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc4, '-') + '</span>\
            <span class="live-score' + (setnow == 5 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc5, '-') + '</span>';
    } else if (sportTypeId == 37) {
        overviewHtml += '<span class="live-time">' + smart(fixture.match.mt, '', '\'') + '</span>\
            <span class="live-period">' + fixture.match.st + '</span>\
            <span class="live-score' + (setnow == 1 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc1, '-') + '</span>\
            <span class="live-score' + (setnow == 2 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc2, '-') + '</span>\
            <span class="live-score' + (setnow == 3 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc3, '-') + '</span>\
            <span class="live-score' + (setnow == 4 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc4, '-') + '</span>\
            <span class="live-score' + (setnow == 5 ? '-current' : '') + '">' + getLiveScore(fixture.match.sc5, '-') + '</span>';
    }
    return overviewHtml;
}
function overviewBetTypeGroupTemplate(data, isValid) {
    var overviewHtml = '';
    if (typeof data.odds[0].ho != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 1) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + data.odds[0].foid + ',1,\'l\')' : 'return false; coupon(' + data.odds[0].foid + ',1,\'l\')';
        overviewHtml += '<a id="odd' + data.odds[0].foid + '_1" class="btn coupon-effect odd ' + isValid + ' ' + selClass + '" data-fixture="' + data.fid + '" onclick="' + couponclick + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + data.odds[0].hs + '</span>\
                <span class="rate-rate">' + data.odds[0].ho.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    if (typeof data.odds[0].do != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 0) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + data.odds[0].foid + ',0,\'l\')' : 'return false; coupon(' + data.odds[0].foid + ',0,\'l\')';
        overviewHtml += '<a id="odd' + data.odds[0].foid + '_0" class="btn coupon-effect odd ' + isValid + ' ' + selClass + '" data-fixture="' + data.fid + '" onclick="' + couponclick + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + data.odds[0].ds + '</span>\
                <span class="rate-rate">' + data.odds[0].do.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    if (typeof data.odds[0].ao != 'undefined') {
        var selClass = (existsInCoupon(data.odds[0].foid, 2) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + data.odds[0].foid + ',2,\'l\')' : 'return false; coupon(' + data.odds[0].foid + ',2,\'l\')';
        overviewHtml += '<a id="odd' + data.odds[0].foid + '_2" class="btn coupon-effect odd ' + isValid + ' ' + selClass + '" data-fixture="' + data.fid + '" onclick="' + couponclick + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + data.odds[0].as + '</span>\
                <span class="rate-rate">' + data.odds[0].ao.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    return overviewHtml;
}
function liveFixtureTemplate(fixture) {
    if (fixture.match.bs == 'ended') {
        window.location.replace(pronetTradDom + '#mobile/live');
    }
    //Video Stream
    if (fixture.ils) {
        $('.livescoreboard-headwrap').show();
    } else {
        $('.livescoreboard-headwrap').hide();
    }
    var fixtureHtml = '';
    fixtureHtml += '<div data-page="live_fixture" class="row">\
        <div class="header-title" style="display:none;">\
            <a class="left-button nav-back-btn"><span class="glyphicon glyphicon-chevron-left"></span></a>\
            <div class="inscroll line-double">\
                <div id="wrapper">\
                    <div id="scroller">\
                        <ul class="list-inline pad0 margin0">\
                            <li>\
                                <div>\
                                    <span class="sportmain"><i class="sporttype' + fixture.stid + '"></i></span>\
                                    ' + fixture.hcn + ' - ' + fixture.acn + '\
                                </div>\
                                <div class="sub-text textnone f80"><span class="flagmain"><i class="flag' + fixture.cid + '"></i></span><span>' + fixture.cn + ' ' + fixture.sn + '</span></div>\
                            </li>\
                        </ul>\
                    </div>\
                </div>\
            </div>\
        </div>\
    </div>\
    <div class="row">\
        <div class="live-event-wrap live-theme' + fixture.stid + '">\
            <table id="live_detail_table' + fixture.fid + '" class="live-detail-table">';
    fixtureHtml += fixtureDetailTable(fixture);
    fixtureHtml += '</table>\
        </div>\
    </div>';
    fixtureHtml += '<div class="row">\
        <div class="top-scroll-bar">\
            <div id="wrapper1">\
                <div id="scroller">\
                    <ul class="list-inline top-scroll-icons pad0 margin0">';
    fixtureHtml += getBetTypeGroupMarketMenu(fixture.stid);
    fixtureHtml += '</ul>\
                </div>\
            </div>\
        </div>\
    </div>';
    fixtureHtml += '<div class="row pad-sm">\
        <div id="live_bet_type_grid" class="fixture-grid">';
    $.each(fixture.btgs, function (key, btg) {
        fixtureHtml += fixtureBetTypeGroupTemplate(btg, fixture.valid);
    });
    fixtureHtml += '</div>\
    </div>';
    return fixtureHtml;
}
function fixtureBetTypeGroupTemplate(btg, isValid) {
    var btgmid = smart($.address.parameter('lbtg'), 0);
    var display;
    if(btgmid == 0){
        display = 'block';
    }else{
        display = (btg.btgmid == btgmid) ? ('block') : ('none');
    }
    var fixtureHtml = '';
    var betTypeGroupMarketId = (btg.btgmid == null) ? 0 : btg.btgmid;
    fixtureHtml += '<div id="live_bet_type' + btg.btgid + '" class="panel bet-type live-bet-type" style="display:'+display+'" data-order="' + btg.o + '" data-group-market="' + betTypeGroupMarketId + '">\
        <div>\
            <div class="panel-heading bet-main-title pointer" data-toggle="collapse" data-target="#live_btg_collapse' + btg.btgid + '">' + btg.btgname + '</div>\
            <div id="live_btg_collapse' + btg.btgid + '" class="fixture-sporttype collapse collapse-bet-type in">\
                <div id="live_btg' + btg.btgid + '" class="ratesgrid">';
    $.each(btg.odds, function (key, fixtureOdd) {
        fixtureHtml += fixtureOddTemplate(fixtureOdd, isValid);
    });
    fixtureHtml += '</div>\
            </div>\
        </div>\
    </div>';
    return fixtureHtml;
}
function fixtureOddTemplate(fixtureOdd, valid) {
    var isValid = valid ? 'anaoran' : 'anadisabled';
    var fixtureHtml = '';
    if (typeof fixtureOdd.do == 'undefined' && typeof fixtureOdd.ao == 'undefined') {
        fixtureHtml += '<div class="btn-group-sm col-xs-6 col-sm-4 pad0" data-btg="' + fixtureOdd.btgid + '_' + fixtureOdd.oho + '">';
    } else {
        fixtureHtml += '<div class="btn-group btn-group-justified btn-group-sm" data-btg="' + fixtureOdd.btgid + '_' + fixtureOdd.oho + '">';
    }
    if (typeof fixtureOdd.ho != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 1) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + fixtureOdd.foid + ',1,\'l\')' : 'return false; coupon(' + fixtureOdd.foid + ',1,\'l\')';
        fixtureHtml += '<a id="odd_d' + fixtureOdd.foid + '_1" onclick="' + couponclick + '" data-fixture="' + curfixtureId + '" class="btn odd_d ' + isValid + ' ' + selClass + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + fixtureOdd.hs + '</span>\
                <span class="rate-rate">' + fixtureOdd.ho.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    if (typeof fixtureOdd.do != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 0) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + fixtureOdd.foid + ',0,\'l\')' : 'return false; coupon(' + fixtureOdd.foid + ',0,\'l\')';
        fixtureHtml += '<a id="odd_d' + fixtureOdd.foid + '_0" onclick="' + couponclick + '" data-fixture="' + curfixtureId + '" class="btn odd_d ' + isValid + ' ' + selClass + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + fixtureOdd.ds + '</span>\
                <span class="rate-rate">' + fixtureOdd.do.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    if (typeof fixtureOdd.ao != 'undefined') {
        var selClass = (existsInCoupon(fixtureOdd.foid, 2) ? 'anaselected' : '');
        var couponclick = (isValid == 'anaoran') ? 'coupon(' + fixtureOdd.foid + ',2,\'l\')' : 'return false; coupon(' + fixtureOdd.foid + ',2,\'l\')';
        fixtureHtml += '<a id="odd_d' + fixtureOdd.foid + '_2" onclick="' + couponclick + '" data-fixture="' + curfixtureId + '" class="btn odd_d ' + isValid + ' ' + selClass + '">\
            <div class="rate-inner">\
                <span class="rate-name">' + fixtureOdd.as + '</span>\
                <span class="rate-rate">' + fixtureOdd.ao.toFixed(2) + '</span>\
            </div>\
        </a>';
    }
    fixtureHtml += '</div>';
    return fixtureHtml;
}
function fixtureDetailTable(fixture) {
    var fixtureHtml = '';
    var score = fixture.match.sc.split(':');
    var setnow = fixture.match.st.substring(0, 1);
    if (fixture.stid == 1) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 2 || fixture.stid == 3) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">1.Ç</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">2.Ç</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">3.Ç</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">4.Ç</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 0) + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
                <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 1) + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 4 || fixture.stid == 9 || fixture.stid == 10) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">1.Ç</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">2.Ç</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">3.Ç</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 0) + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 1) + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 5) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">Skor</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 6) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">Skor</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 28) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">Skor</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 35 || fixture.stid == 36) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">O</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">1.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">2.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">3.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">4.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">5.S</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">';
        if (smart(fixture.match.server, '0') == '1') {
            fixtureHtml += '<span class="live-ball"><i class="fa fa-circle"></i></span>';
        }
        fixtureHtml += '</td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + getLiveScore2(fixture.match.gamescore, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 5 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc5, '-', 0) + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">';
        if (smart(fixture.match.server, '0') == '2') {
            fixtureHtml += '<span class="live-ball"><i class="fa fa-circle"></i></span>';
        }
        fixtureHtml += '</td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + getLiveScore2(fixture.match.gamescore, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 5 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc5, '-', 1) + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 37) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">1.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">2.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">3.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">4.S</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">5.S</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 0) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 5 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc5, '-', 0) + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 1 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc1, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 2 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc2, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 3 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc3, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 4 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc4, '-', 1) + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live' + (setnow == 5 ? 'current' : 'before') + '">' + getLiveScore2(fixture.match.sc5, '-', 1) + '</span>\
        </tr>';
    } else if (fixture.stid == 23 || fixture.stid == 28) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">Skor</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    } else if (fixture.stid == 16 || fixture.stid == 20 || fixture.stid == 29) {
        fixtureHtml += '<tr>\
            <td class="live-detail-title">\
               <span class="live-sub">' + fixture.match.st + ' ' + smart(fixture.match.mt, '', '\'') + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-sub">Skor</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-yellow-card"></span>\
            </td>\
            <td class="live-detail-info">\
               <span class="live-red-card"></span>\
            </td>\
            <td class="live-detail-info">\
                <span class="live-corner"><i class="fa fa-flag"></i></span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.hcn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[0] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.ych, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rch, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ch, '-') + '</span>\
            </td>\
        </tr>\
        <tr class="darkbg2">\
            <td class="live-detail-title">\
               <span class="live-event-teamname">' + fixture.acn + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livecurrent">' + score[1] + '</span>\
            </td>\
            <td class="live-detail-info">\
                <span class="livebefore">' + smart(fixture.match.yca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.rca, '-') + '</span>\
            </td>\
            <td class="live-detail-info">\
               <span class="livebefore">' + smart(fixture.match.ca, '-') + '</span>\
            </td>\
        </tr>';
    }
    return fixtureHtml;
}