String.prototype.toNum = function () {
    if (this == '' || this == ' ')
        return 0;
    return parseFloat(this);
}
String.prototype.toInt = function () {
    if (this == '' || this == ' ')
        return 0;
    return parseInt(this);
}
Number.prototype.toNum = function () {
    if (this == '' || this == ' ' || isNaN(this))
        return 0;
    return parseFloat(this);
}
Number.prototype.toInt = function () {
    if (this == '' || this == ' ' || isNaN(this))
        return 0;
    return parseInt(this);
}
String.prototype.formatNumber = function (params) {
    return numeral(this).format(params);
}
Number.prototype.formatNumber = function (params) {
    return numeral(this).format(params);
}
$.fn.countdown = function(callback, duration, message) {
    message = message || '';
    var container = $(this[0]).html(duration + message);
    var countdown = setInterval(function() {
        if (--duration) {
            container.html(duration + message);
        } else {
            clearInterval(countdown);
            callback.call(container);
        }
    }, 1000);
};
$.fn.validateForm = function(){
    var form = $(this);
    if(!form.is('form'))
        form = form.find('form');
    form.bootstrapValidator('validate');
    return form.data('bootstrapValidator').isValid();
}
$.fn.steps = function (options) {
    options = $.extend({startIndex: 0}, options);
    return this.each(function () {
        var wizard = $(this);
        var children = wizard.find('.step-field');

        if (typeof options.childSelector != 'undefined') {
            children = wizard.find(options.childSelector);
        }

        var state = {
            currentIndex: options.startIndex,
            stepCount: children.length
        };

        wizard.data('options', options);
        wizard.data('state', state);

        children.hide().slice(options.startIndex, options.startIndex + 1).show();

        wizard.bind('finishing', options.onFinishing);
        wizard.bind('finished', options.onFinished);
        wizard.bind('stepChanging', options.onStepChanging);
        wizard.bind('stepChanged', options.onStepChanged);
    });
}
$.fn.goToStep = function (options, state, index) {
    return this.each(function () {
        var wizard = $(this);
        var oldIndex = state.currentIndex;

        if (state.currentIndex == state.stepCount - 1 && index > state.currentIndex) {
            wizard.finishStep();
            return;
        }
        if (typeof options.onStepChanging != 'undefined' && !wizard.triggerHandler('stepChanging', [state.currentIndex, index]))
            return;

        state.currentIndex = index;
        var children = wizard.find('.step-field');
        children.hide().slice(index, index + 1).show();
        wizard.triggerHandler('stepChanged', [index, oldIndex]);
    });
}
$.fn.finishStep = function () {
    return this.each(function () {
        var wizard = $(this);
        var options = wizard.data('options');
        var state = wizard.data('state');

        if (typeof options.onStepChanging != 'undefined' && !wizard.triggerHandler('finishing', [state.currentIndex]))
            return;

        wizard.triggerHandler('finished', [state.currentIndex]);
    });
}
$.fn.goToNextStep = function () {
    return this.each(function () {
        var wizard = $(this);
        var options = wizard.data('options');
        var state = wizard.data('state');
        wizard.goToStep(options, state, state.currentIndex + 1);
    });
}
$.fn.goToPreviousStep = function () {
    return this.each(function () {
        var wizard = $(this);
        var options = wizard.data('options');
        var state = wizard.data('state');
        wizard.goToStep(options, state, state.currentIndex - 1);
    });
}
$.fn.successMessage = function (message) {
    return this.each(function () {
        $(this).find('.success-alert > .message').html(message);
        $(this).find('.success-alert').show();
    });
}
$.fn.failIdentify = function () {
    return this.each(function () {
        $(this).find('.fail-identify').show();
    });
}

$.fn.failIdentifyMessage = function (message) {
    return this.each(function () {
       $(this).find('.fail-identify > .message').html(message);
    });
}

$.fn.failMessage = function (message) {
    return this.each(function () {
        $(this).find('.fail-alert > .message').html(message);
        $(this).find('.fail-alert').show();
    });
}

$.fn.hideMessages = function (message) {
    return this.each(function () {
        $(this).find('.success-alert > .message').html('');
        $(this).find('.success-alert').hide();
        $(this).find('.fail-alert > .message').html('');
        $(this).find('.fail-alert').hide();
        $(this).find('.fail-identify > .message').html('');
        $(this).find('.fail-identify').hide();
    });
}
$.fn.resetForm = function () {
    return this.each(function () {
        $(this).find('input,textarea').val('');
    });
}
$.fn.animateScrollTop = function () {
    $('html,body').animate({scrollTop: this.position().top}, 'slow');
}
$.fn.pageMe = function (options) {
    options = $.extend({perPage: 7}, options);

    var wizard = $(this);
    var children = wizard.children();
    var pager = $('.content-pager');

    if (typeof options.childSelector != 'undefined') {
        children = wizard.find(options.childSelector);
    }
    if (typeof options.pagerSelector != 'undefined') {
        pager = $(options.pagerSelector);
    }

    if (children.length <= options.perPage) {
        pager.hide();
    } else {
        pager.show();
    }

    var numItems = children.size();
    var numPages = Math.ceil(numItems / options.perPage);

    pager.data('current', 0);

    children.hide().slice(0, options.perPage).show();

    pager.find('#more_btn').click(function () {
        showMore(+1);
        return false;
    });
    pager.find('#goTop_btn').click(function () {
        children.eq(0).animateScrollTop();
        return false;
    });

    function showMore(dir) {
        var index = (pager.data('current').toInt() + dir);
        children.hide().slice(0, (options.perPage * index) + options.perPage).show();
        pager.data('current', index);
        if (index == (numPages - 1)) {
            pager.find('#more_btn').attr('disabled', true);
        } else {
            pager.find('#more_btn').attr('disabled', false);
        }
        children.eq(options.perPage * index).animateScrollTop();
    }
}