<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Kontrol_futbol_canli_anlik extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }

static function macin_detayi_anlik($mac_id){

$where=array();
$where["mac_id"]=$mac_id;
$sonuc=self::$db->Where($where)->Select("durum,iy,ft,ms,ums,pms")->Get("bulten")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc;    
}
}
static function siradaki_gol_zamani_anlik($mac_id,$kacinci){
$where=array();
$where["mac_id"]=$mac_id;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("time AS dakika")->Get("maclar_goller",1,$kacinci)->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->dakika;    
}
}
static function kontrolfutbol_anlik($iybittimi,$mac_id,$iy,$ms,$grup,$tur,$ilk_gol,$son_gol,$s1=0,$s2=0,$s3=0,$s4=0,$s5=0,$s6=0,$s7=0,$s8=0,$s9=0,$s10=0,$s11=0){
$iy_bol = explode("-",$iy);
$ft_bol = explode("-",$ms);

//ilk yarı gol sayıları
$iy_ev = $iy_bol[0];
$iy_konuk = $iy_bol[1];

//ikinci yarı gol sayılari
$ik_ev=$ft_bol[0]-$iy_bol[0];
$ik_konuk=$ft_bol[1]-$iy_bol[1];


//maç sonucu gol sayıları
$ft_ev = $ft_bol[0];
$ft_konuk = $ft_bol[1];

//toplam gol sayıları
$iy_toplamgol = $iy_ev+$iy_konuk;
$ik_toplamgol = $ik_ev+$ik_konuk;

$toplam_gol = $ft_ev+$ft_konuk;


if($grup=="2.5 Gol Alt / Üst") {
      if($tur=="2.5 Üst"  && $toplam_gol>2.5){ return "1"; }
      
  }

else if($grup=="İki Takım da Gol Atar") {
      if($tur=="Evet"  && $ft_ev !=0 && $ft_konuk !=0) { return "1"; }
  }
else if($grup=="Alt / Üst") {
      if($tur=="0.5 Üst"  && $toplam_gol>0.5){ return "1"; }else
      if($tur=="1.5 Üst"  && $toplam_gol>1.5){ return "1"; }else
      if($tur=="2.5 Üst"  && $toplam_gol>2.5){ return "1"; }else
      if($tur=="3.5 Üst"  && $toplam_gol>3.5){ return "1"; }else
      if($tur=="4.5 Üst"  && $toplam_gol>4.5){ return "1"; }else
      if($tur=="5.5 Üst"  && $toplam_gol>5.5){ return "1"; }else
      if($tur=="6.5 Üst"  && $toplam_gol>6.5){ return "1"; }else 
      if($tur=="7.5 Üst"  && $toplam_gol>7.5){ return "1"; }else
      if($tur=="8.5 Üst"  && $toplam_gol>8.5){ return "1"; }else
      if($tur=="9.5 Üst"  && $toplam_gol>9.5){ return "1"; }
      
  }
else if($grup=="Toplam Gol Sayısı") {
      if($tur=="6 ve Üzeri"  && $toplam_gol>=6){ return "1"; }
      
  }
else if($grup=="1. Yarı Toplam Gol Sayısı" && $iybittimi==1) {
      if($tur=="Gol Olmaz"  && $iy_toplamgol==0) { return "1"; }else 
      if($tur=="1 Gol"  && $iy_toplamgol==1) { return "1"; }else 
      if($tur=="2 Gol"  && $iy_toplamgol==2){ return "1"; }else
      if($tur=="3 Gol"  && $iy_toplamgol==3) { return "1"; }else 
      if($tur=="4 ve Üzeri"  && $iy_toplamgol>=4){ return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Toplam Gol Sayısı") {
      if($tur=="4 ve Üzeri"  && $iy_toplamgol>=4){ return "1"; }
  }
else if($grup=="İlk Golü Atan Takım") {
      if($tur=="Ev Sahibi"  && $ilk_gol==1) { return "1"; }else 
      if($tur=="Misafir"  && $ilk_gol==2){ return "1"; }
      
  }
else if($grup=="Hangi Takım Gol Atar") {
if($tur=="İki Takım da Gol Atar"  && $ft_ev!=0 && $ft_konuk!=0){ return "1"; }
      
  }  
else if($grup=="1. Yarı Sonucu" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==$iy_konuk){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<$iy_konuk) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Handikap 0:1" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk+1) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==$iy_konuk+1){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<$iy_konuk+1) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Beraberlikte İade" && $iybittimi==1) {
 if($iy_ev==$iy_konuk){return "5"; }else{
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk) { return "1"; }else 
      if($tur=="Misafir"  && $iy_ev<$iy_konuk) { return "1"; }else
      { return "2"; }
      
    }
  }
else if($grup=="1. Yarı Çifte Şans" && $iybittimi==1) {
      if($tur=="1 / X"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk)) { return "1"; }else 
      if($tur=="1 / 2"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk)){ return "1"; }else
      if($tur=="X / 2"  && ($iy_ev<$iy_konuk || $iy_ev==$iy_konuk)) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Çifte Şans ve 1. Yarı  İki Takım da Gol Atar" && $iybittimi==1) {
      if($tur=="1-X / Evet"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="1-X / Hayır"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk) && ($iy_ev==0 || $iy_konuk==0) ) { return "1"; }else 
      if($tur=="1-2 / Evet"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="1-2 / Hayır"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk) && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }else 
      if($tur=="X-2 / Evet"  && ($iy_ev==$iy_konuk || $iy_ev<$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="X-2 / Hayır"  && ($iy_ev==$iy_konuk || $iy_ev<$iy_konuk) && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }else
      { return "2"; }
   
      
  }
else if($grup=="1. Yarı Sonucu ve 1. Yarı 1.5 Alt / Üst" && $iybittimi==1) {
      if($tur=="Ev Sahibi ve 1.5 Alt"  && $iy_ev>$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 1.5 Üst"  && $iy_ev>$iy_konuk && $iy_toplamgol>1.5){ return "1"; }else
      if($tur=="Beraberlik ve 1.5 Alt"  && $iy_ev==$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="Beraberlik ve 1.5 Üst"  && $iy_ev==$iy_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Alt"  && $iy_ev<$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Üst"  && $iy_ev<$iy_konuk && $iy_toplamgol>1.5) { return "1"; }else
      { return "2"; }
      
  }
else if(($grup=="1. Yarı Sonucu ve 1. Yarı İki Takım da Gol Atar" || $grup=="1. Yarı Sonucu ve 1. Yarıda İki Takım Gol Atar")&& $iybittimi==1) {
      if($tur=="Misafir / Evet"   && $iy_ev !=0 && $iy_konuk!=0 && $iy_ev<$iy_konuk) { return "1"; }else 
      if($tur=="Ev Sahibi / Evet"   && $iy_ev!=0 && $iy_konuk!=0 && $iy_ev>$iy_konuk){ return "1"; }else
      if($tur=="Beraberlik / Evet"  && $iy_ev !=0 && $iy_konuk!=0 && $iy_ev==$iy_konuk) { return "1"; }else
      if($tur=="Misafir / Hayır"  && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev<$iy_konuk) { return "1"; }else
      if($tur=="Ev Sahibi / Hayır"  && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev>$iy_konuk) { return "1"; }else
      if($tur=="Beraberlik / Hayır" && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev==$iy_konuk) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı İlk Golü Atan Takım" && $iybittimi==1) {
      if($tur=="Ev Sahibi"   && $ilk_gol==1) { return "1"; }else 
      if($tur=="Gol Olmaz"   && $ilk_gol==0){ return "1"; }else
      if($tur=="Misafir"  && $ilk_gol==2) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı İlk Golü Atan Takım") {
      if($tur=="Ev Sahibi"   && $ilk_gol==1) { return "1"; }else 
      if($tur=="Misafir"  && $ilk_gol==2) { return "1"; }     
  }
else if($grup=="1. Yarı Toplam Gol" && $iybittimi==1) {
      if($tur=="Gol Olmaz" && $iy_ev+$iy_konuk==0) { return "1"; }else
      if($tur=="1 Gol" && $iy_ev+$iy_konuk==1) { return "1"; }else
      if($tur=="2 ve Üzeri" && $iy_ev+$iy_konuk>=2) { return "1"; }else
      { return "2"; }
      
      
  }
else if($grup=="1. Yarı Toplam Gol") {
      if($tur=="2 ve Üzeri" && $iy_ev+$iy_konuk>=2) { return "1"; }          
  }
else if($grup=="1. Yarı Ev Sahibi Gol Sayısı" && $iybittimi==1) {
      if($tur=="1 Gol"  && $iy_ev==1) { return "1"; }else 
      if($tur=="2 Gol"  && $iy_ev==2){ return "1"; }else
      if($tur=="Gol Atamaz"  && $iy_ev==0) { return "1"; }else 
      if($tur=="3 ve Üzeri"  && $iy_ev>=3){ return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Ev Sahibi Gol Sayısı") {
      if($tur=="3 ve Üzeri"  && $iy_ev>=3){ return "1"; }
  }
else if(($grup=="1. Yarı Deplasman Gol Sayısı" || $grup=="1. Yarı Misafir Gol Sayısı") && $iybittimi==1) {
      if($tur=="1 Gol"  && $iy_konuk==1) { return "1"; }else 
      if($tur=="2 Gol"  && $iy_konuk==2){ return "1"; }else
      if($tur=="Gol Atamaz"  && $iy_konuk==0) { return "1"; }else 
      if($tur=="3 ve Üzeri"  && $iy_konuk>=3){ return "1"; }
      else { return "2"; }
  }
else if(($grup=="1. Yarı Deplasman Gol Sayısı" || $grup=="1. Yarı Misafir Gol Sayısı")) {
      if($tur=="3 ve Üzeri"  && $iy_konuk>=3){ return "1"; }
  }
else if($grup=="1. Yarı Alt / Üst" && $iybittimi==1) {
      if($tur=="0.5 Üst" && $iy_ev+$iy_konuk>0.5) { return "1"; }else
      if($tur=="0.5 Alt" && $iy_ev+$iy_konuk<0.5) { return "1"; }else
      if($tur=="1.5 Üst" && $iy_ev+$iy_konuk>1.5) { return "1"; }else
      if($tur=="1.5 Alt" && $iy_ev+$iy_konuk<1.5) { return "1"; }else
      if($tur=="2.5 Üst" && $iy_ev+$iy_konuk>2.5) { return "1"; }else
      if($tur=="2.5 Alt" && $iy_ev+$iy_konuk<2.5) { return "1"; }else
      if($tur=="3.5 Üst" && $iy_ev+$iy_konuk>3.5) { return "1"; }else
      if($tur=="3.5 Alt" && $iy_ev+$iy_konuk<3.5) { return "1"; }else
      if($tur=="4.5 Üst" && $iy_ev+$iy_konuk>4.5) { return "1"; }else
      if($tur=="4.5 Alt" && $iy_ev+$iy_konuk<4.5) { return "1"; }else
      if($tur=="5.5 Üst" && $iy_ev+$iy_konuk>5.5) { return "1"; }else
      if($tur=="5.5 Alt" && $iy_ev+$iy_konuk<5.5) { return "1"; }else
      if($tur=="6.5 Üst" && $iy_ev+$iy_konuk>6.5) { return "1"; }else
      if($tur=="6.5 Alt" && $iy_ev+$iy_konuk<6.5) { return "1"; }else
      if($tur=="7.5 Üst" && $iy_ev+$iy_konuk>7.5) { return "1"; }else
      if($tur=="7.5 Alt" && $iy_ev+$iy_konuk<7.5) { return "1"; }else
      if($tur=="8.5 Üst" && $iy_ev+$iy_konuk>8.5) { return "1"; }else
      if($tur=="8.5 Alt" && $iy_ev+$iy_konuk<8.5) { return "1"; }else
      { return "2"; }
    
      

      
  }
else if($grup=="1. Yarı Alt / Üst") {
      if($tur=="0.5 Üst" && $iy_ev+$iy_konuk>0.5) { return "1"; }else
      if($tur=="1.5 Üst" && $iy_ev+$iy_konuk>1.5) { return "1"; }else
      if($tur=="2.5 Üst" && $iy_ev+$iy_konuk>2.5) { return "1"; }else
      if($tur=="3.5 Üst" && $iy_ev+$iy_konuk>3.5) { return "1"; }else
      if($tur=="4.5 Üst" && $iy_ev+$iy_konuk>4.5) { return "1"; }else
      if($tur=="5.5 Üst" && $iy_ev+$iy_konuk>5.5) { return "1"; }else
      if($tur=="6.5 Üst" && $iy_ev+$iy_konuk>6.5) { return "1"; }else
      if($tur=="7.5 Üst" && $iy_ev+$iy_konuk>7.5) { return "1"; }else
      if($tur=="8.5 Üst" && $iy_ev+$iy_konuk>8.5) { return "1"; }    
  }
else if($grup=="1. Yarı Kaç Gol Olur" && $iybittimi==1) {
      if($tur=="1 veya 2" && $iy_ev+$iy_konuk<3) { return "1"; }else
      if($tur=="1, 2, veya 3" && $iy_ev+$iy_konuk<4) { return "1"; }else
      if($tur=="2 veya 3" && $iy_ev+$iy_konuk>1 && $iy_ev+$iy_konuk<4) { return "1"; }else
      if($tur=="4 ve Üzeri" && $iy_ev+$iy_konuk>3) { return "1"; }else
      if($tur=="Gol Olmaz" && $iy_ev+$iy_konuk==0) { return "1"; }else
      { return "2"; }
  }
else if($grup=="1. Yarı Kaç Gol Olur") {
      if($tur=="4 ve Üzeri" && $iy_ev+$iy_konuk>3) { return "1"; }
  }
else if($grup=="1. Yarı Ev Sahibi Alt / Üst" && $iybittimi==1) {
      if($tur=="0.5 Alt"  && $iy_ev<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $iy_ev>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $iy_ev<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $iy_ev>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $iy_ev<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $iy_ev>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $iy_ev<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $iy_ev>3.5){ return "1"; }else
      if($tur=="4.5 Alt"  && $iy_ev<4.5) { return "1"; }else 
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Misafir Alt / Üst" && $iybittimi==1) {
      if($tur=="0.5 Alt"  && $iy_konuk<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $iy_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $iy_konuk<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $iy_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $iy_konuk<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $iy_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $iy_konuk<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $iy_konuk>3.5){ return "1"; }else
      if($tur=="4.5 Alt"  && $iy_ev<4.5) { return "1"; }else 
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Ev Sahibi Alt / Üst") {
      if($tur=="0.5 Üst"  && $iy_ev>0.5){ return "1"; }else
      if($tur=="1.5 Üst"  && $iy_ev>1.5){ return "1"; }else
      if($tur=="2.5 Üst"  && $iy_ev>2.5){ return "1"; }else
      if($tur=="3.5 Üst"  && $iy_ev>3.5){ return "1"; }else
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }      
  }
else if($grup=="1. Yarı Misafir Alt / Üst") {
      if($tur=="0.5 Üst"  && $iy_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Üst"  && $iy_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Üst"  && $iy_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Üst"  && $iy_konuk>3.5){ return "1"; }else
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }      
  }
else if($grup=="1. Yarı Ev Sahibi Gol Yemez" && $iybittimi==1) {
      if($tur=="Gol Yemez"  && $iy_konuk==0) { return "1"; }else 
      if($tur=="Gol Yer"    && $iy_konuk>0){ return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Misafir Gol Yemez" && $iybittimi==1) {
      if($tur=="Gol Yemez"  && $iy_ev==0) { return "1"; }else 
      if($tur=="Gol Yer"  && $iy_ev>0){ return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarıda İki Takım da Gol Atar" && $iybittimi==1) {
      if($tur=="Evet" && $iy_ev!=0 && $iy_konuk!=0) { return "1"; }else
      if($tur=="Hayır" && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }else
      { return "2"; }   
  }
else if($grup=="1. Yarı Ev Sahibi Gol Yemez") {
      if($tur=="Gol Yer"    && $iy_konuk>0){ return "1"; }      
  }
else if($grup=="1. Yarı Misafir Gol Yemez") {
      if($tur=="Gol Yer"  && $iy_ev>0){ return "1"; }
  }
else if($grup=="1. Yarıda İki Takım da Gol Atar") {
      if($tur=="Evet" && $iy_ev!=0 && $iy_konuk!=0) { return "1"; }
  }
else if($grup=="1. Yarı Tek / Çift" && $iybittimi==1) {
      if($tur=="Çift" && $iy_toplamgol%2==0) { return "1"; }else
      if($tur=="Tek" && $iy_toplamgol%2!=0) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="1. Yarı Handikap 1:0" && $iybittimi==1) {
      if($tur=="Misafir"   && $iy_ev+1<$iy_konuk) { return "1"; }else 
      if($tur=="Ev Sahibi"   && $iy_ev+1>$iy_konuk){ return "1"; }else
      if($tur=="Beraberlik"  && $iy_ev+1==$iy_konuk) { return "1"; }else
      { return "2"; }
      
  }
else if($grup=="Ev Sahibi Gol Sayısı") {
      if($tur=="3 ve Üzeri"  && $ft_ev>=3){ return "1"; }
      
  }
else if($grup=="Ev Sahibi Alt / Üst") {
      if($tur=="0.5 Üst"  && $ft_ev>0.5){ return "1"; }else
      if($tur=="1.5 Üst"  && $ft_ev>1.5){ return "1"; }else
      if($tur=="2.5 Üst"  && $ft_ev>2.5){ return "1"; }else
      if($tur=="3.5 Üst"  && $ft_ev>3.5){ return "1"; }
      
}
else if($grup=="Ev Sahibi Kaç Gol Atar") {
      if($tur=="4 ve Üzeri"  && $ft_ev>3) { return "1"; }
      
  }
else if($grup=="Ev Sahibi Gol Yemez") {
      if($tur=="Gol Yer"    && $ft_konuk>0){ return "1"; }
      
  }
else if($grup=="Misafir Gol Yemez") {
      if($tur=="Gol Yer"    && $ft_ev>0){ return "1"; }
      
  }
else if($grup=="Misafir Gol Sayısı") {
      if($tur=="3 ve Üzeri"  && $ft_konuk>=3){ return "1"; }
      
  }
else if($grup=="Misafir Alt / Üst") {
      if($tur=="0.5 Üst"  && $ft_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Üst"  && $ft_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Üst"  && $ft_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Üst"  && $ft_konuk>3.5){ return "1"; }
      
}
else if($grup=="Misafir Kaç Gol Atar") {
      if($tur=="4 ve Üzeri"  && $ft_konuk>3) { return "1"; }
      
  }
else if($grup=="1. Yarı Skoru" && $iybittimi==1) {
      if($tur=="0:5" && $iy_ev==0 && $iy_konuk==5) { return "1"; }else
      if($tur=="0:4" && $iy_ev==0 && $iy_konuk==4) { return "1"; }else
      if($tur=="1:3" && $iy_ev==1 && $iy_konuk==3) { return "1"; }else
      if($tur=="0:3" && $iy_ev==0 && $iy_konuk==3) { return "1"; }else
      if($tur=="1:2" && $iy_ev==1 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:2" && $iy_ev==0 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:1" && $iy_ev==0 && $iy_konuk==1) { return "1"; }else
      if($tur=="1:1" && $iy_ev==1 && $iy_konuk==1) { return "1"; }else
      if($tur=="2:2" && $iy_ev==2 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:0" && $iy_ev==0 && $iy_konuk==0) { return "1"; }else
      if($tur=="1:0" && $iy_ev==1 && $iy_konuk==0) { return "1"; }else
      if($tur=="5:0" && $iy_ev==5 && $iy_konuk==0) { return "1"; }else
      if($tur=="4:0" && $iy_ev==4 && $iy_konuk==0) { return "1"; }else
      if($tur=="3:1" && $iy_ev==3 && $iy_konuk==1) { return "1"; }else
      if($tur=="3:0" && $iy_ev==3 && $iy_konuk==0) { return "1"; }else
      if($tur=="2:1" && $iy_ev==2 && $iy_konuk==1) { return "1"; }else
      if($tur=="2:0" && $iy_ev==2 && $iy_konuk==0) { return "1"; }
      else { return "2"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 0:0 )") {
      if($tur=="Ev Sahibi"  && $s1==1) { return "1"; }else 
      if($tur=="Misafir"  && $s1==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 1:0 )") {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Misafir"  && $s2==2) { return "1"; }
      
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 1:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Gol Olmaz" && $s2==0){ return "1"; }else
      if($tur=="Misafir"  && $s2==2) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 1:0 )") {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Misafir"  && $s2==2) { return "1"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 0:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $s1==1) { return "1"; }else 
      if($tur=="Gol Olmaz" && $s1==0){ return "1"; }else
      if($tur=="Misafir"  && $s1==2) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 0:0 )") {
      if($tur=="Ev Sahibi"  && $s1==1) { return "1"; }else 
      if($tur=="Misafir"  && $s1==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 2:0 )") {
      if($tur=="Ev Sahibi"  && $s3==1) { return "1"; }else 
      if($tur=="Misafir"  && $s3==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 3:0 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
      
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 3:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Gol Olmaz" && $s4==0){ return "1"; }else
      if($tur=="Misafir"  && $s4==2) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 3:0 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 0:1 )") {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Misafir"  && $s2==2) { return "1"; }
      
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 0:1 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Gol Olmaz" && $s2==0){ return "1"; }else
      if($tur=="Misafir"  && $s2==2) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 0:1 )") {
      if($tur=="Ev Sahibi"  && $s2==1) { return "1"; }else 
      if($tur=="Misafir"  && $s2==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 0:2 )") {
      if($tur=="Ev Sahibi"  && $s3==1) { return "1"; }else 
      if($tur=="Misafir"  && $s3==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 0:3 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 1:1 )") {
      if($tur=="Ev Sahibi"  && $s3==1) { return "1"; }else 
      if($tur=="Misafir"  && $s3==2) { return "1"; }
      
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 1:1 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $s3==1) { return "1"; }else 
      if($tur=="Gol Olmaz" && $s3==0){ return "1"; }else
      if($tur=="Misafir"  && $s3==2) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Sıradaki Gol ( Skor: 1:1 )") {
      if($tur=="Ev Sahibi"  && $s3==1) { return "1"; }else 
      if($tur=="Misafir"  && $s3==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 1:2 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 3:1 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
      
}
else if($grup=="Sıradaki Gol ( Skor: 1:3 )") {
      if($tur=="Ev Sahibi"  && $s5==1) { return "1"; }else 
      if($tur=="Misafir"  && $s5==2) { return "1"; }
      
}
else if($grup=="Sıradaki Gol ( Skor: 1:4 )") {
      if($tur=="Ev Sahibi"  && $s6==1) { return "1"; }else 
      if($tur=="Misafir"  && $s6==2) { return "1"; }
      
}
else if($grup=="Sıradaki Gol ( Skor: 2:2 )") {
      if($tur=="Ev Sahibi"  && $s5==1) { return "1"; }else 
      if($tur=="Misafir"  && $s5==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 2:1 )") {
      if($tur=="Ev Sahibi"  && $s4==1) { return "1"; }else 
      if($tur=="Misafir"  && $s4==2) { return "1"; }
  }
else if($grup=="Sıradaki Gol ( Skor: 4:4 )") {
      if($tur=="Ev Sahibi"  && $s9==1) { return "1"; }else 
      if($tur=="Misafir"  && $s9==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 4:0 )") {
      if($tur=="Ev Sahibi"  && $s5==1) { return "1"; }else 
      if($tur=="Misafir"  && $s5==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 5:0 )") {
      if($tur=="Ev Sahibi"  && $s6==1) { return "1"; }else 
      if($tur=="Misafir"  && $s6==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Gol ( Skor: 0:5 )") {
      if($tur=="Ev Sahibi"  && $s6==1) { return "1"; }else 
      if($tur=="Misafir"  && $s6==2) { return "1"; }
      
  }
else if($grup=="Sıradaki Golün Zamanı 10 Dakika Aralığı ( Skor: 0:0 )") {
$ilk_gol_zamani=self::siradaki_gol_zamani_anlik($mac_id,0);
//print_r($ilk_gol_zamani);
      if($tur=="1 - 10 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=10) { return "1"; }else 
      if($tur=="11 - 20 Arası" && $ilk_gol_zamani>=11 && $ilk_gol_zamani<=20){ return "1"; }else
      if($tur=="21 - 30 Arası"  && $ilk_gol_zamani>=21 && $ilk_gol_zamani<=30) { return "1"; }else
      if($tur=="31 - 40 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=40) { return "1"; }else
      if($tur=="41 - 50 Arası"  && $ilk_gol_zamani>=41 && $ilk_gol_zamani<=50) { return "1"; }else
      if($tur=="51 - 60 Arası"  && $ilk_gol_zamani>=51 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 70 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=70) { return "1"; }else
      if($tur=="71 - 80 Arası"  && $ilk_gol_zamani>=71 && $ilk_gol_zamani<=80) { return "1"; }else
      if($tur=="81 - 90+ Arası"  && $ilk_gol_zamani>=81 ) { return "1"; }
  }
else if($grup=="Sıradaki Golün Zamanı 10 Dakika Aralığı ( Skor: 0:1 )") {
$ilk_gol_zamani=self::siradaki_gol_zamani_anlik($mac_id,1);
//print_r($ilk_gol_zamani);
      if($tur=="1 - 10 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=10) { return "1"; }else 
      if($tur=="11 - 20 Arası" && $ilk_gol_zamani>=11 && $ilk_gol_zamani<=20){ return "1"; }else
      if($tur=="21 - 30 Arası"  && $ilk_gol_zamani>=21 && $ilk_gol_zamani<=30) { return "1"; }else
      if($tur=="31 - 40 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=40) { return "1"; }else
      if($tur=="41 - 50 Arası"  && $ilk_gol_zamani>=41 && $ilk_gol_zamani<=50) { return "1"; }else
      if($tur=="51 - 60 Arası"  && $ilk_gol_zamani>=51 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 70 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=70) { return "1"; }else
      if($tur=="71 - 80 Arası"  && $ilk_gol_zamani>=71 && $ilk_gol_zamani<=80) { return "1"; }else
      if($tur=="81 - 90+ Arası"  && $ilk_gol_zamani>=81 ) { return "1"; }
  }
else if($grup=="Sıradaki Golün Zamanı 15 Dakika Aralığı ( Skor: 0:0 )") {

$ilk_gol_zamani=self::siradaki_gol_zamani_anlik($mac_id,0);

      if($tur=="1 - 15 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=15) { return "1"; }else 
      if($tur=="16 - 30 Arası" && $ilk_gol_zamani>=16 && $ilk_gol_zamani<=30){ return "1"; }else
      if($tur=="31 - 45 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=45) { return "1"; }else
      if($tur=="46 - 60 Arası"  && $ilk_gol_zamani>=46 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 75 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=75) { return "1"; }else
      if($tur=="76 - 90+ Arası"  && $ilk_gol_zamani>=76) { return "1"; }
  }
else if($grup=="Sıradaki Golün Zamanı 15 Dakika Aralığı ( Skor: 0:1 )") {

$ilk_gol_zamani=self::siradaki_gol_zamani_anlik($mac_id,1);

      if($tur=="1 - 15 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=15) { return "1"; }else 
      if($tur=="16 - 30 Arası" && $ilk_gol_zamani>=16 && $ilk_gol_zamani<=30){ return "1"; }else
      if($tur=="31 - 45 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=45) { return "1"; }else
      if($tur=="46 - 60 Arası"  && $ilk_gol_zamani>=46 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 75 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=75) { return "1"; }else
      if($tur=="76 - 90+ Arası"  && $ilk_gol_zamani>=76) { return "1"; }
  }
else if($grup=="1. Yarı Kalan Sürede Kim Kazanır ( Skor: 0:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev>($iy_konuk)) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==($iy_konuk)){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<($iy_konuk)) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Kalan Sürede Kim Kazanır ( Skor: 1:1 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev-1>($iy_konuk-1)) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev-1==($iy_konuk-1)){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev-1<($iy_konuk-1)) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Kalan Sürede Kim Kazanır ( Skor: 0:1 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev>($iy_konuk-1)) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==($iy_konuk-1)){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<($iy_konuk-1)) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Kalan Sürede Kim Kazanır ( Skor: 1:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev-1>($iy_konuk)) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev-1==($iy_konuk)){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev-1<($iy_konuk)) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Kalan Sürede Kim Kazanır ( Skor: 3:0 )" && $iybittimi==1) {
      if($tur=="Ev Sahibi"  && $iy_ev-3>($iy_konuk)) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev-3==($iy_konuk)){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev-3<($iy_konuk)) { return "1"; }
      else { return "2"; }
  }
else if($grup=="1. Yarı Handikap 2:0" && $iybittimi==1) {
    if($tur=="Ev Sahibi" && (($iy_ev + 2) > $iy_konuk)) { return "1"; } else
      if($tur=="Beraberlik" && (($iy_ev + 2) == $iy_konuk)) { return "1"; } else
      if($tur=="Misafir" && (($iy_ev + 2) < $iy_konuk)) { return "1"; } else { return "2"; }    
  }
else if($grup=="1. Yarı Handikap 0:2" && $iybittimi==1) {
    if($tur=="Ev Sahibi" && (($iy_ev) > $iy_konuk + 2)) { return "1"; } else
      if($tur=="Beraberlik" && (($iy_ev) == $iy_konuk + 2)) { return "1"; } else
      if($tur=="Misafir" && (($iy_ev) < $iy_konuk + 2)) { return "1"; } else { return "2"; }    
  }
else if($grup=="1. Yarı Handikap 0:3" && $iybittimi==1) {
    if($tur=="Ev Sahibi" && (($iy_ev) > $iy_konuk + 3)) { return "1"; } else
      if($tur=="Beraberlik" && (($iy_ev) == $iy_konuk + 3)) { return "1"; } else
      if($tur=="Misafir" && (($iy_ev) < $iy_konuk + 3)) { return "1"; } else { return "2"; }    
  }
else if($grup=="1. Yarı Handikap 0:4" && $iybittimi==1) {
    if($tur=="Ev Sahibi" && (($iy_ev) > $iy_konuk + 4)) { return "1"; } else
      if($tur=="Beraberlik" && (($iy_ev) == $iy_konuk + 4)) { return "1"; } else
      if($tur=="Misafir" && (($iy_ev) < $iy_konuk + 4)) { return "1"; } else { return "2"; }    
  }
 
  else
  {
    return "0";
  }





//fonksiyon sonu
}
   

  

  

}

/* End of file model.php */
