<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Kontrol_futbol extends CI_Model
{
    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }

static function ilk_gol_zamani($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("Min(maclar_goller.time) AS dakika")->Get("maclar_goller")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->dakika;    
}
}

static function ikinci_yari_ilk_golu_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$where["time>="]=46;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("atan")->Get("maclar_goller")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function ilk_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("atan")->Get("maclar_kornerler")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function birinci_yari_ilk_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$where["time<="]=45;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("atan")->Get("maclar_kornerler")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function ikinci_yari_ilk_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$where["time>="]=46;
$sonuc=self::$db->Where($where)->order_by("time", "ASC")->Select("atan")->Get("maclar_kornerler")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function birinci_yari_son_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$where["time<="]=45;
$sonuc=self::$db->Where($where)->order_by("time", "DESC")->Select(" atan")->Get("maclar_kornerler")->row();
//print_r($sonuc);
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function ikinci_yari_son_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$where["time>="]=46;
$sonuc=self::$db->Where($where)->order_by("time", "DESC")->Select("atan")->Get("maclar_kornerler")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;    
}
}

static function son_korner_atan($mac_id){
$where=array();
$where["mac_id"]=$mac_id;
$sonuc=self::$db->Where($where)->order_by("time", "DESC")->Select("atan")->Get("maclar_kornerler")->row();
if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->atan;
}
}

static function korner_sayisi($mac_id,$dakika_bas,$dakika_bit){

$where=array();

$where["mac_id"]=$mac_id;
$where["time>="]=$dakika_bas;
$where["time<="]=$dakika_bit;

$sonuc=self::$db->Where($where)->Select("Count(maclar_kornerler.Id) AS toplam")->Get("maclar_kornerler")->row();

if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->toplam;    
}
}

static function takim_korner_sayisi($mac_id,$takim,$dakika_bas,$dakika_bit){

$where=array();

$where["mac_id"]=$mac_id;
$where["atan"]=$takim;
$where["time>="]=$dakika_bas;
$where["time<="]=$dakika_bit;

$sonuc=self::$db->Where($where)->Select("Count(maclar_kornerler.Id) AS toplam")->Get("maclar_kornerler")->row();

if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->toplam;    
}

}


static function son_gol_zamani($mac_id){

$where=array();

$where["mac_id"]=$mac_id;

$sonuc=self::$db->Where($where)->Select("Max(maclar_goller.time) AS dakika")->Get("maclar_goller")->row();

if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->dakika;    
}
}



static function gol_sayilari($mac_id,$takim,$bas_dak,$bit_dak){
$where=array();

$where["mac_id"]=$mac_id;
$where["atan"]=$takim;
$where["time>"]=$bas_dak;
$where["time<"]=$bit_dak;

$sonuc=self::$db->Where($where)->Select("Count(maclar_goller.Id) AS toplam")->Get("maclar_goller")->row();

if(count($sonuc)==0){
return 0;  
}else{
return $sonuc->toplam;    
}
}
static function kontrolfutbol($mac_id,$iy,$ms,$grup,$tur,$ilk_gol,$son_gol)
    {

$iy_bol = explode("-",$iy);
$ft_bol = explode("-",$ms);

//ilk yarı gol sayıları
$iy_ev = $iy_bol[0];
$iy_konuk = $iy_bol[1];

//ikinci yarı gol sayılari
$ik_ev=$ft_bol[0]-$iy_bol[0];
$ik_konuk=$ft_bol[1]-$iy_bol[1];

//maç sonucu gol sayıları
$ft_ev = $ft_bol[0];
$ft_konuk = $ft_bol[1];

//toplam gol sayıları
$iy_toplamgol = $iy_ev+$iy_konuk;
$ik_toplamgol = $ik_ev+$ik_konuk;

$toplam_gol = $ft_ev+$ft_konuk;


if($grup=="Maç Sonucu") {
      if($tur=="Ev Sahibi"  && $ft_ev>$ft_konuk) { return "1"; }else 
      if($tur=="Beraberlik" && $ft_ev==$ft_konuk){ return "1"; }else
      if($tur=="Misafir"  && $ft_ev<$ft_konuk) { return "1"; }
      else { return "2"; }
  }
else if($grup=="Beraberlikte İade") {
      
      if($ft_ev==$ft_konuk){return "5"; }else{
      if($tur=="Ev Sahibi"  && $ft_ev>$ft_konuk) { return "1"; }else 
      if($tur=="Misafir"  && $ft_ev<$ft_konuk) { return "1"; }
      else { return "2"; }
    }
  }


else if($grup=="Çifte Şans") {
      if($tur=="1 / X"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk)) { return "1"; }else 
      if($tur=="1 / 2"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk)){ return "1"; }else
      if($tur=="X / 2"  && ($ft_ev<$ft_konuk || $ft_ev==$ft_konuk)) { return "1"; }
      else { return "2"; }
  }

else if($grup=="2.5 Gol Alt / Üst") {
      if($tur=="2.5 Alt"  && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $toplam_gol>2.5){ return "1"; }
      else { return "2"; }
  }


  else if($grup=="Handikap 0:1") {
    if($tur=="Ev Sahibi" && (($ft_konuk + 1) < $ft_ev)) { return "1"; } else
      if($tur=="Beraberlik" && (($ft_konuk + 1) == $ft_ev)) { return "1"; } else
      if($tur=="Misafir" && (($ft_konuk + 1) > $ft_ev)) { return "1"; } else { return "2"; }
	  
  }
  
  else if($grup=="Handikap 0:2") {
    if($tur=="Ev Sahibi" && (($ft_konuk + 2) < $ft_ev)) { return "1"; } else
      if($tur=="Beraberlik" && (($ft_konuk + 2) == $ft_ev)) { return "1"; } else
      if($tur=="Misafir" && (($ft_konuk + 2) > $ft_ev)) { return "1"; } else { return "2"; }
    
  }


 else if($grup=="Handikap 1:0") {
    if($tur=="Ev Sahibi" && (($ft_ev + 1) > $ft_konuk)) { return "1"; } else
      if($tur=="Beraberlik" && (($ft_ev + 1) == $ft_konuk)) { return "1"; } else
      if($tur=="Misafir" && (($ft_ev + 1) < $ft_konuk)) { return "1"; } else { return "2"; }
    
  }

  else if($grup=="Handikap 2:0") {
    if($tur=="Ev Sahibi" && (($ft_ev + 2) > $ft_konuk)) { return "1"; } else
      if($tur=="Beraberlik" && (($ft_ev + 2) == $ft_konuk)) { return "1"; } else
      if($tur=="Misafir" && (($ft_ev + 2) < $ft_konuk)) { return "1"; } else { return "2"; }    
  }
  

  else if($grup=="Ev Sahibi Kazanırsa İade") {

    if($ft_ev>$ft_konuk){return "5"; }else{
    if($tur=="Beraberlik" && $ft_ev==$ft_konuk) { return "1"; } else
    if($tur=="Misafir" && $ft_ev<$ft_konuk) { return "1"; } else { return "2"; }    
    }
  }

  else if($grup=="Misafir Kazanırsa İade") {

    if($ft_ev<$ft_konuk){return "5"; }else{
    if($tur=="Beraberlik" && $ft_ev==$ft_konuk) { return "1"; } else
    if($tur=="Ev Sahibi" && $ft_ev>$ft_konuk) { return "1"; } else { return "2"; }    
    }
  }

else if($grup=="Hangi Takım, Kaç Farkla Kazanır") {
      if($tur=="Ev Sahibi 1 Farkla"   && $ft_ev-1==$ft_konuk) { return "1"; }else 
      if($tur=="Misafir 1 Farkla"   && $ft_ev==$ft_konuk-1){ return "1"; }else
      if($tur=="Ev Sahibi 2 Farkla"  && $ft_ev-2==$ft_konuk){ return "1"; }else
      if($tur=="Misafir 2 Farkla"  && $ft_ev==$ft_konuk-2){ return "1"; }else
      if($tur=="Ev Sahibi 3 ve Üzeri Farkla"  && $ft_ev-3>$ft_konuk){ return "1"; }else
      if($tur=="Misafir 3 ve Üzeri Farkla"  && $ft_ev<$ft_konuk-3){ return "1"; }
      else { return "2"; }
  }


 else if($grup=="İki Takım da Gol Atar (1. Yarı / 2. Yarı)") {
      if($tur=="Evet / Evet"  && $iy_ev >0 && $iy_konuk>0 && $ik_ev>0 && $ik_konuk>0) { return "1"; }else 
      if($tur=="Hayır / Hayır" && $iy_ev==0 && $iy_konuk==0 && $ik_ev==0 && $ik_konuk==0){ return "1"; }else
      if($tur=="Evet / Hayır"  && $iy_ev !=0 && $iy_konuk!=0 && $ik_ev ==0 && $ik_konuk ==0) { return "1"; }else
      if($tur=="Hayır / Evet"  && $iy_ev ==0 && $iy_konuk==0 && $ik_ev !=0 && $ik_konuk !=0) { return "1"; }
      else { return "2"; }
  }



  else if($grup=="İlk Yarı / Maç Sonucu") {
      if($tur=="1 / 1"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk) { return "1"; }else 
      if($tur=="1 / X"  && $iy_ev>$iy_konuk && $ft_ev==$ft_konuk){ return "1"; }else
      if($tur=="1 / 2"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk) { return "1"; }else
      if($tur=="X / 1"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk) { return "1"; }else
      if($tur=="X / X"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk) { return "1"; }else
      if($tur=="X / 2"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk) { return "1"; }else
      if($tur=="2 / 1"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk) { return "1"; }else
      if($tur=="2 / X"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk) { return "1"; }else
      if($tur=="2 / 2"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk) { return "1"; }
      else { return "2"; }
  }
 
  else if($grup=="Alt / Üst") {
      if($tur=="0.5 Alt"  && $toplam_gol<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $toplam_gol>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $toplam_gol>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $toplam_gol>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $toplam_gol>3.5){ return "1"; }else
      if($tur=="4.5 Alt"  && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="4.5 Üst"  && $toplam_gol>4.5){ return "1"; }else
      if($tur=="5.5 Alt"  && $toplam_gol<5.5) { return "1"; }else 
      if($tur=="5.5 Üst"  && $toplam_gol>5.5){ return "1"; }else
      if($tur=="6.5 Alt"  && $toplam_gol<6.5) { return "1"; }else 
      if($tur=="6.5 Üst"  && $toplam_gol>6.5){ return "1"; }else 
      if($tur=="7.5 Alt"  && $toplam_gol<7.5) { return "1"; }else 
      if($tur=="7.5 Üst"  && $toplam_gol>7.5){ return "1"; }else
      if($tur=="8.5 Alt"  && $toplam_gol<8.5) { return "1"; }else 
      if($tur=="8.5 Üst"  && $toplam_gol>8.5){ return "1"; }else
      if($tur=="9.5 Alt"  && $toplam_gol<9.5) { return "1"; }else 
      if($tur=="9.5 Üst"  && $toplam_gol>9.5){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Toplam Gol Sayısı") {
      if($tur=="1 Gol"  && $toplam_gol==1) { return "1"; }else 
      if($tur=="2 Gol"  && $toplam_gol==2){ return "1"; }else
      if($tur=="3 Gol"  && $toplam_gol==3) { return "1"; }else 
      if($tur=="4 Gol"  && $toplam_gol==4){ return "1"; }else
      if($tur=="5 Gol"  && $toplam_gol==5) { return "1"; }else 
      if($tur=="6 ve Üzeri"  && $toplam_gol>=6){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Gol Aralığı") {
      if($tur=="0-1 Gol"  && ($toplam_gol==0 || $toplam_gol==1)) { return "1"; }else 
      if($tur=="2-3 Gol"  && ($toplam_gol==2 || $toplam_gol==3)){ return "1"; }else
      if($tur=="4-5 Gol"  && ($toplam_gol==4 || $toplam_gol==5)) { return "1"; }else 
      if($tur=="6+ Gol"   && $toplam_gol>=6){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="İlk Golü Atan Takım") {

      if($tur=="Ev Sahibi"  && $ilk_gol==1) { return "1"; }else 
      if($tur=="Gol Olmaz"  && $ilk_gol==0) { return "1"; }else 
      if($tur=="Misafir"  && $ilk_gol==2){ return "1"; }
      else { return "2"; }
  }
 else if($grup=="Son Golü Atan Takım") {

      if($tur=="Ev Sahibi"  && $son_gol==1) { return "1"; }else 
      if($tur=="Gol Olmaz"  && $ilk_gol==0) { return "1"; }else 
      if($tur=="Misafir"  && $son_gol==2){ return "1"; }
      else { return "2"; }
  }

 else if($grup=="Kaç Gol Olur") {

      if($tur=="1 veya 2"  && $toplam_gol>0 && $toplam_gol<3) { return "1"; }else 
      if($tur=="1, 2, veya 3"  && $toplam_gol>0 && $toplam_gol<4) { return "1"; }else 
      if($tur=="1, 2, 3, veya 4"  && $toplam_gol>0 && $toplam_gol<5) { return "1"; }else 
      if($tur=="1, 2, 3, 4, veya 5"  && $toplam_gol>0 && $toplam_gol<6) { return "1"; }else 
      if($tur=="1, 2, 3, 4, 5, veya 6"  && $toplam_gol>0 && $toplam_gol<7) { return "1"; }else 
      if($tur=="2 veya 3"  && ($toplam_gol>1 && $toplam_gol<4)) { return "1"; }else 
      if($tur=="2, 3, veya 4"  && $toplam_gol>1 && $toplam_gol<5) { return "1"; }else 
      if($tur=="2, 3, 4, veya 5"  && $toplam_gol>1 && $toplam_gol<6) { return "1"; }else 
      if($tur=="2, 3, 4, 5, veya 6"  && $toplam_gol>1 && $toplam_gol<7) { return "1"; }else 
      if($tur=="3 veya 4"  && ($toplam_gol>2 && $toplam_gol<5)) { return "1"; }else 
      if($tur=="3, 4, veya 5"  && $toplam_gol>2 && $toplam_gol<6) { return "1"; }else 
      if($tur=="3, 4, 5, veya 6"  && $toplam_gol>2 && $toplam_gol<7) { return "1"; }else 
      if($tur=="4 veya 5"  && $toplam_gol>3 && $toplam_gol<6) { return "1"; }else 
      if($tur=="4, 5, veya 6"  && $toplam_gol>3 && $toplam_gol<7) { return "1"; }else 
      if($tur=="5 veya 6"  && $toplam_gol>4 && $toplam_gol<7) { return "1"; }else 
      if($tur=="7 ve Üzeri"  && $toplam_gol>6) { return "1"; }else 
      if($tur=="Gol Olmaz"  && $toplam_gol==0) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="İlk Gol / Maç Sonucu") {

 if($tur=="Ev Sahibi / Ev Sahibi"  && $ilk_gol==1 && $ft_ev>$ft_konuk) { return "1"; }else 
 if($tur=="Misafir / Ev Sahibi"  && $ilk_gol==2 && $ft_ev>$ft_konuk) { return "1"; }else 
 if($tur=="Ev Sahibi / Beraberlik"  && $ilk_gol==1 && $ft_ev==$ft_konuk) { return "1"; }else 
 if($tur=="Misafir / Beraberlik"  && $ilk_gol==2 && $ft_ev==$ft_konuk) { return "1"; }else 
 if($tur=="Ev Sahibi / Misafir"  && $ilk_gol==1 && $ft_ev<$ft_konuk) { return "1"; }else 
 if($tur=="Misafir / Misafir"  && $ilk_gol==2 && $ft_ev<$ft_konuk) { return "1"; }
      else { return "2"; }

}
else if($grup=="İki Takım da Gol Atar") {
      if($tur=="Evet"  && $ft_ev !=0 && $ft_konuk !=0) { return "1"; }else 
      if($tur=="Hayır"  && ($ft_ev ==0 || $ft_konuk ==0)){ return "1"; }
      else { return "2"; }
  }

else if($grup=="İki Takım da Gol Atar ve 2.5 Alt / Üst") {
      if($tur=="Evet / 2.5 Alt"   && $ft_ev !=0 && $ft_konuk !=0 && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="Evet / 2.5 Üst"   && $ft_ev !=0 && $ft_konuk !=0 && $toplam_gol>2.5){ return "1"; }else
      if($tur=="Hayır / 2.5 Alt"  && ($ft_ev ==0 || $ft_konuk ==0) && $toplam_gol<2.5){ return "1"; }else
      if($tur=="Hayır / 2.5 Üst"  && ($ft_ev ==0 || $ft_konuk ==0) && $toplam_gol>2.5){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Hangi Takım Gol Atar") {
      if($tur=="Sadece Ev Sahibi"  && $ft_ev>0 && $ft_konuk==0) { return "1"; }else 
      if($tur=="Sadece Misafir"  && $ft_ev==0 && $ft_konuk>0){ return "1"; }else
      if($tur=="İki Takım da Gol Atar"  && $ft_ev!=0 && $ft_konuk!=0){ return "1"; }else
      if($tur=="Gol Olmaz"  && $ft_ev==0 && $ft_konuk==0) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Hangi Yarı Daha Fazla Gol Olur") {
      if($tur=="1. Yarı" && $iy_toplamgol>$ik_toplamgol) { return "1"; }else 
      if($tur=="Eşit" && $iy_toplamgol==$ik_toplamgol){ return "1"; }else
      if($tur=="2. Yarı" && $iy_toplamgol<$ik_toplamgol){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Maç Sonucu ve 1.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 1.5 Alt"  && $ft_ev>$ft_konuk && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 1.5 Üst"  && $ft_ev>$ft_konuk && $toplam_gol>1.5){ return "1"; }else
      if($tur=="Beraberlik ve 1.5 Alt"  && $ft_ev==$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="Beraberlik ve 1.5 Üst"  && $ft_ev==$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Alt"  && $ft_ev<$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Üst"  && $ft_ev<$ft_konuk && $toplam_gol>1.5) { return "1"; }
      else { return "2"; }
  }
  
  else if($grup=="Maç Sonucu ve 2.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 2.5 Alt"  && $ft_ev>$ft_konuk && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 2.5 Üst"  && $ft_ev>$ft_konuk && $toplam_gol>2.5){ return "1"; }else
      if($tur=="Beraberlik ve 2.5 Alt"  && $ft_ev==$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="Beraberlik ve 2.5 Üst"  && $ft_ev==$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="Misafir ve 2.5 Alt"  && $ft_ev<$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="Misafir ve 2.5 Üst"  && $ft_ev<$ft_konuk && $toplam_gol>2.5) { return "1"; }
      else { return "2"; }
  }
  
  else if($grup=="Maç Sonucu ve 3.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 3.5 Alt"  && $ft_ev>$ft_konuk && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 3.5 Üst"  && $ft_ev>$ft_konuk && $toplam_gol>3.5){ return "1"; }else
      if($tur=="Beraberlik ve 3.5 Alt"  && $ft_ev==$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="Beraberlik ve 3.5 Üst"  && $ft_ev==$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="Misafir ve 3.5 Alt"  && $ft_ev<$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="Misafir ve 3.5 Üst"  && $ft_ev<$ft_konuk && $toplam_gol>3.5) { return "1"; }
      else { return "2"; }
  }
  
  else if($grup=="Maç Sonucu ve 4.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 4.5 Alt"  && $ft_ev>$ft_konuk && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 4.5 Üst"  && $ft_ev>$ft_konuk && $toplam_gol>4.5){ return "1"; }else
      if($tur=="Beraberlik ve 4.5 Alt"  && $ft_ev==$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="Beraberlik ve 4.5 Üst"  && $ft_ev==$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="Misafir ve 4.5 Alt"  && $ft_ev<$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="Misafir ve 4.5 Üst"  && $ft_ev<$ft_konuk && $toplam_gol>4.5) { return "1"; }
      else { return "2"; }
  }
  
  else if($grup=="Maç Sonucu ve 5.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 5.5 Alt"  && $ft_ev>$ft_konuk && $toplam_gol<5.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 5.5 Üst"  && $ft_ev>$ft_konuk && $toplam_gol>5.5){ return "1"; }else
      if($tur=="Beraberlik ve 5.5 Alt"  && $ft_ev==$ft_konuk && $toplam_gol<5.5) { return "1"; }else
      if($tur=="Beraberlik ve 5.5 Üst"  && $ft_ev==$ft_konuk && $toplam_gol>5.5) { return "1"; }else
      if($tur=="Misafir ve 5.5 Alt"  && $ft_ev<$ft_konuk && $toplam_gol<5.5) { return "1"; }else
      if($tur=="Misafir ve 5.5 Üst"  && $ft_ev<$ft_konuk && $toplam_gol>5.5) { return "1"; }
      else { return "2"; }
  }

    else if($grup=="Maç Sonucu ve İki Takım da Gol Atar") {
      if($tur=="Ev Sahibi / Evet"  && $ft_ev>$ft_konuk && $ft_ev !=0 && $ft_konuk !=0) { return "1"; }else 
      if($tur=="Ev Sahibi / Hayır"  && $ft_ev>$ft_konuk && ($ft_ev ==0 || $ft_konuk ==0)){ return "1"; }else
      if($tur=="Beraberlik / Evet"  && $ft_ev==$ft_konuk && $ft_ev !=0 && $ft_konuk !=0) { return "1"; }else
      if($tur=="Beraberlik / Hayır"  && $ft_ev==$ft_konuk && ($ft_ev ==0 || $ft_konuk ==0)) { return "1"; }else
      if($tur=="Misafir / Evet"  && $ft_ev<$ft_konuk && $ft_ev !=0 && $ft_konuk !=0) { return "1"; }else
      if($tur=="Misafir / Hayır"  && $ft_ev<$ft_konuk && ($ft_ev ==0 || $ft_konuk ==0)) { return "1"; }
      else { return "2"; }
  }

   else if($grup=="Çifte Şans ve 1.5 Alt / Üst") {
      if($tur=="1-X / 1.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="1-X / 1.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol>1.5) { return "1"; }else 
      if($tur=="1-2 / 1.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="1-2 / 1.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>1.5) { return "1"; }else 
      if($tur=="X-2 / 1.5 Alt"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="X-2 / 1.5 Üst"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>1.5) { return "1"; }
      else { return "2"; }
  }

   else if($grup=="Çifte Şans ve 2.5 Alt / Üst") {
      if($tur=="1-X / 2.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="1-X / 2.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol>2.5) { return "1"; }else 
      if($tur=="1-2 / 2.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="1-2 / 2.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>2.5) { return "1"; }else 
      if($tur=="X-2 / 2.5 Alt"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="X-2 / 2.5 Üst"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>2.5) { return "1"; }
      else { return "2"; }
  }
  else if($grup=="Çifte Şans ve 3.5 Alt / Üst") {
      if($tur=="1-X / 3.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="1-X / 3.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol>3.5) { return "1"; }else 
      if($tur=="1-2 / 3.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="1-2 / 3.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>3.5) { return "1"; }else 
      if($tur=="X-2 / 3.5 Alt"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="X-2 / 3.5 Üst"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>3.5) { return "1"; }
      else { return "2"; }
  }
  else if($grup=="Çifte Şans ve 4.5 Alt / Üst") {
      if($tur=="1-X / 4.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="1-X / 4.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol>4.5) { return "1"; }else 
      if($tur=="1-2 / 4.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="1-2 / 4.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>4.5) { return "1"; }else 
      if($tur=="X-2 / 4.5 Alt"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="X-2 / 4.5 Üst"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>4.5) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Çifte Şans ve 5.5 Alt / Üst") {
      if($tur=="1-X / 5.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol<5.5) { return "1"; }else 
      if($tur=="1-X / 5.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $toplam_gol>5.5) { return "1"; }else 
      if($tur=="1-2 / 5.5 Alt"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<5.5) { return "1"; }else 
      if($tur=="1-2 / 5.5 Üst"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>5.5) { return "1"; }else 
      if($tur=="X-2 / 5.5 Alt"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol<5.5) { return "1"; }else 
      if($tur=="X-2 / 5.5 Üst"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $toplam_gol>5.5) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Çifte Şans ve İki Takım da Gol Atar") {
      if($tur=="1-X / Evet"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && $ft_konuk>0 && $ft_ev>0) { return "1"; }else 
      if($tur=="1-X / Hayır"  && ($ft_ev>$ft_konuk || $ft_ev==$ft_konuk) && ($ft_konuk==0 || $ft_ev==0) ) { return "1"; }else 
      if($tur=="1-2 / Evet"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && $ft_konuk>0 && $ft_ev>0) { return "1"; }else 
      if($tur=="1-2 / Hayır"  && ($ft_ev>$ft_konuk || $ft_ev<$ft_konuk) && ($ft_konuk==0 || $ft_ev==0) ) { return "1"; }else 
      if($tur=="X-2 / Evet"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && $ft_konuk>0 && $ft_ev>0) { return "1"; }else 
      if($tur=="X-2 / Hayır"  && ($ft_ev==$ft_konuk || $ft_ev<$ft_konuk) && ($ft_konuk==0 || $ft_ev==0) ) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Her İki Yarı da 1,5 Alt Biter") {
      if($tur=="Evet" && $iy_toplamgol<1.5 && $ik_toplamgol<1.5) { return "1"; }else 
      if($tur=="Hayır" && ($iy_toplamgol>1.5 ||$ik_toplamgol>1.5)){ return "1"; }
      else { return "2"; }
  }
  
  else if($grup=="Her İki Yarı da 1,5 Üst Biter") {
      if($tur=="Evet" && $iy_toplamgol>1.5 && $ik_toplamgol>1.5) { return "1"; }else 
      if($tur=="Hayır" && ($iy_toplamgol<1.5 ||$ik_toplamgol<1.5)){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Tek / Çift Gol") {
      if($tur=="Tek"  && $toplam_gol%2!=0) { return "1"; }else 
      if($tur=="Çift"  && $toplam_gol%2==0){ return "1"; }
      else { return "2"; }
  }

    else if($grup=="1. Yarı Sonucu") {
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==$iy_konuk){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<$iy_konuk) { return "1"; }
      else { return "2"; }
  }
  
    else if($grup=="1. Yarı Handikap 0:1") {
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk+1) { return "1"; }else 
      if($tur=="Beraberlik" && $iy_ev==$iy_konuk+1){ return "1"; }else
      if($tur=="Misafir"  && $iy_ev<$iy_konuk+1) { return "1"; }
      else { return "2"; }
  }

else if($grup=="1. Yarı Beraberlikte İade") {
 if($iy_ev==$iy_konuk){return "5"; }else{
      if($tur=="Ev Sahibi"  && $iy_ev>$iy_konuk) { return "1"; }else 
      if($tur=="Misafir"  && $iy_ev<$iy_konuk) { return "1"; }
      else { return "2"; }
    }
  }

   else if($grup=="1. Yarı Çifte Şans") {
      if($tur=="1 / X"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk)) { return "1"; }else 
      if($tur=="1 / 2"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk)){ return "1"; }else
      if($tur=="X / 2"  && ($iy_ev<$iy_konuk || $iy_ev==$iy_konuk)) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Çifte Şans ve 1. Yarı  İki Takım da Gol Atar") {
      if($tur=="1-X / Evet"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="1-X / Hayır"  && ($iy_ev>$iy_konuk || $iy_ev==$iy_konuk) && ($iy_ev==0 || $iy_konuk==0) ) { return "1"; }else 
      if($tur=="1-2 / Evet"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="1-2 / Hayır"  && ($iy_ev>$iy_konuk || $iy_ev<$iy_konuk) && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }else 
      if($tur=="X-2 / Evet"  && ($iy_ev==$iy_konuk || $iy_ev<$iy_konuk) && $iy_ev>0 && $iy_konuk>0) { return "1"; }else 
      if($tur=="X-2 / Hayır"  && ($iy_ev==$iy_konuk || $iy_ev<$iy_konuk) && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }
   
      else { return "2"; }
  }

  else if($grup=="1. Yarı Sonucu ve 1. Yarı 1.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 1.5 Alt"  && $iy_ev>$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else 
      if($tur=="Ev Sahibi ve 1.5 Üst"  && $iy_ev>$iy_konuk && $iy_toplamgol>1.5){ return "1"; }else
      if($tur=="Beraberlik ve 1.5 Alt"  && $iy_ev==$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="Beraberlik ve 1.5 Üst"  && $iy_ev==$iy_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Alt"  && $iy_ev<$iy_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Üst"  && $iy_ev<$iy_konuk && $iy_toplamgol>1.5) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Sonucu ve 1. Yarı İki Takım da Gol Atar") {
      if($tur=="Misafir / Evet"   && $iy_ev !=0 && $iy_konuk!=0 && $iy_ev<$iy_konuk) { return "1"; }else 
      if($tur=="Ev Sahibi / Evet"   && $iy_ev!=0 && $iy_konuk!=0 && $iy_ev>$iy_konuk){ return "1"; }else
      if($tur=="Beraberlik / Evet"  && $iy_ev !=0 && $iy_konuk!=0 && $iy_ev==$iy_konuk) { return "1"; }else
      if($tur=="Misafir / Hayır"  && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev<$iy_konuk) { return "1"; }else
      if($tur=="Ev Sahibi / Hayır"  && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev>$iy_konuk) { return "1"; }else
      if($tur=="Beraberlik / Hayır" && ($iy_ev ==0 || $iy_konuk==0) && $iy_ev==$iy_konuk) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı İlk Golü Atan Takım") {
      if($tur=="Ev Sahibi"   && $ilk_gol==1) { return "1"; }else 
      if($tur=="Gol Olmaz"   && $ilk_gol==0){ return "1"; }else
      if($tur=="Misafir"  && $ilk_gol==2) { return "1"; }
      else { return "2"; }
  }


 else if($grup=="1. Yarı Toplam Gol") {
      if($tur=="Gol Olmaz" && $iy_ev+$iy_konuk==0) { return "1"; }else
      if($tur=="1 Gol" && $iy_ev+$iy_konuk==1) { return "1"; }else
      if($tur=="2 ve Üzeri" && $iy_ev+$iy_konuk>=2) { return "1"; }
      
      else { return "2"; }
  }

  else if($grup=="1. Yarı Alt / Üst") {
      if($tur=="0.5 Üst" && $iy_ev+$iy_konuk>0.5) { return "1"; }else
      if($tur=="0.5 Alt" && $iy_ev+$iy_konuk<0.5) { return "1"; }else
      if($tur=="1.5 Üst" && $iy_ev+$iy_konuk>1.5) { return "1"; }else
      if($tur=="1.5 Alt" && $iy_ev+$iy_konuk<1.5) { return "1"; }else
      if($tur=="2.5 Üst" && $iy_ev+$iy_konuk>2.5) { return "1"; }else
      if($tur=="2.5 Alt" && $iy_ev+$iy_konuk<2.5) { return "1"; }else
      if($tur=="3.5 Üst" && $iy_ev+$iy_konuk>3.5) { return "1"; }else
      if($tur=="3.5 Alt" && $iy_ev+$iy_konuk<3.5) { return "1"; }else
      if($tur=="4.5 Üst" && $iy_ev+$iy_konuk>4.5) { return "1"; }else
      if($tur=="4.5 Alt" && $iy_ev+$iy_konuk<4.5) { return "1"; }else
      if($tur=="5.5 Üst" && $iy_ev+$iy_konuk>5.5) { return "1"; }else
      if($tur=="5.5 Alt" && $iy_ev+$iy_konuk<5.5) { return "1"; }else
      if($tur=="6.5 Üst" && $iy_ev+$iy_konuk>6.5) { return "1"; }else
      if($tur=="6.5 Alt" && $iy_ev+$iy_konuk<6.5) { return "1"; }else
      if($tur=="7.5 Üst" && $iy_ev+$iy_konuk>7.5) { return "1"; }else
      if($tur=="7.5 Alt" && $iy_ev+$iy_konuk<7.5) { return "1"; }else
      if($tur=="8.5 Üst" && $iy_ev+$iy_konuk>8.5) { return "1"; }else
      if($tur=="8.5 Alt" && $iy_ev+$iy_konuk<8.5) { return "1"; }

      else { return "2"; }
  }

  else if($grup=="1. Yarı Kaç Gol Olur") {
      if($tur=="1 veya 2" && $iy_ev+$iy_konuk<3) { return "1"; }else
      if($tur=="1, 2, veya 3" && $iy_ev+$iy_konuk<4) { return "1"; }else
      if($tur=="2 veya 3" && $iy_ev+$iy_konuk>1 && $iy_ev+$iy_konuk<4) { return "1"; }else
      if($tur=="4 ve Üzeri" && $iy_ev+$iy_konuk>3) { return "1"; }else
      if($tur=="Gol Olmaz" && $iy_ev+$iy_konuk==0) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Ev Sahibi Alt / Üst") {
      if($tur=="0.5 Alt"  && $iy_ev<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $iy_ev>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $iy_ev<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $iy_ev>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $iy_ev<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $iy_ev>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $iy_ev<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $iy_ev>3.5){ return "1"; }else
      if($tur=="4.5 Alt"  && $iy_ev<4.5) { return "1"; }else 
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Misafir Alt / Üst") {
      if($tur=="0.5 Alt"  && $iy_konuk<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $iy_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $iy_konuk<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $iy_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $iy_konuk<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $iy_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $iy_konuk<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $iy_konuk>3.5){ return "1"; }else
      if($tur=="4.5 Alt"  && $iy_ev<4.5) { return "1"; }else 
      if($tur=="4.5 Üst"  && $iy_ev>4.5){ return "1"; }
      else { return "2"; }
  }

 else if($grup=="1. Yarı Ev Sahibi Gol Yemez") {
      if($tur=="Gol Yemez"  && $iy_konuk==0) { return "1"; }else 
      if($tur=="Gol Yer"    && $iy_konuk>0){ return "1"; }
      else { return "2"; }
  }

 else if($grup=="1. Yarı Misafir Gol Yemez") {
      if($tur=="Gol Yemez"  && $iy_ev==0) { return "1"; }else 
      if($tur=="Gol Yer"  && $iy_ev>0){ return "1"; }
      else { return "2"; }
  }

 else if($grup=="1. Yarıda İki Takım da Gol Atar") {
      if($tur=="Evet" && $iy_ev!=0 && $iy_konuk!=0) { return "1"; }else
      if($tur=="Hayır" && ($iy_ev==0 || $iy_konuk==0)) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Tek / Çift") {
      if($tur=="Çift" && $iy_toplamgol%2==0) { return "1"; }else
      if($tur=="Tek" && $iy_toplamgol%2!=0) { return "1"; }
      else { return "2"; }
  }

   else if($grup=="1. Yarı Handikap 1:0") {
      if($tur=="Misafir"   && $iy_ev+1<$iy_konuk) { return "1"; }else 
      if($tur=="Ev Sahibi"   && $iy_ev+1>$iy_konuk){ return "1"; }else
      if($tur=="Beraberlik"  && $iy_ev+1==$iy_konuk) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Sonucu") {
      if($tur=="Ev Sahibi"  && $ik_ev>$ik_konuk) { return "1"; }else 
      if($tur=="Beraberlik" && $ik_ev==$ik_konuk){ return "1"; }else
      if($tur=="Misafir"  && $ik_ev<$ik_konuk) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Handikap 0:1") {
      if($tur=="Ev Sahibi"  && $ik_ev>$ik_konuk+1) { return "1"; }else 
      if($tur=="Beraberlik" && $ik_ev==$ik_konuk+1){ return "1"; }else
      if($tur=="Misafir"  && $ik_ev<$ik_konuk+1) { return "1"; }
      else { return "2"; }
  }

else if($grup=="2. Yarı Beraberlikte İade") {
 if($ik_ev==$ik_konuk){return "5"; }else{
      if($tur=="Ev Sahibi"  && $ik_ev>$ik_konuk) { return "1"; }else 
      if($tur=="Misafir"  && $ik_ev<$ik_konuk) { return "1"; }
      else { return "2"; }
    }
  }

 else if($grup=="2. Yarı Çifte Şans ve 2. Yarı  İki Takım da Gol Atar") {
      if($tur=="1-X / Evet"  && ($iy_ev>$iy_konuk || $ik_ev==$ik_konuk) && $ik_ev>0 && $ik_konuk>0) { return "1"; }else 
      if($tur=="1-X / Hayır"  && ($iy_ev>$iy_konuk || $ik_ev==$ik_konuk) && ($ik_ev==0 || $ik_konuk==0) ) { return "1"; }else 
      if($tur=="1-2 / Evet"  && ($iy_ev>$iy_konuk || $ik_ev<$ik_konuk) && $ik_ev>0 && $ik_konuk>0) { return "1"; }else 
      if($tur=="1-2 / Hayır"  && ($iy_ev>$iy_konuk || $ik_ev<$ik_konuk) && ($ik_ev==0 || $ik_konuk==0)) { return "1"; }else 
      if($tur=="X-2 / Evet"  && ($iy_ev==$iy_konuk || $ik_ev<$ik_konuk) && $ik_ev>0 && $ik_konuk>0) { return "1"; }else 
      if($tur=="X-2 / Hayır"  && ($iy_ev==$iy_konuk || $ik_ev<$ik_konuk) && ($ik_ev==0 || $ik_konuk==0)) { return "1"; }
   
      else { return "2"; }
  }

 else if($grup=="2. Yarı Sonucu ve 2. Yarı 1.5 Alt / Üst") {
      if($tur=="Ev Sahibi ve 1.5 Üst"  && $ik_ev>$ik_konuk && $ik_ev+$ik_konuk>1.5) { return "1"; }else
      if($tur=="Beraberlik ve 1.5 Üst" && $ik_ev==$ik_konuk && $ik_ev+$ik_konuk>1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Üst"  && $ik_ev<$ik_konuk && $ik_ev+$ik_konuk>1.5) { return "1"; }else
      if($tur=="Ev Sahibi ve 1.5 Alt"  && $ik_ev>$ik_konuk && $ik_ev+$ik_konuk<1.5) { return "1"; }else
      if($tur=="Beraberlik ve 1.5 Alt" && $ik_ev==$ik_konuk && $ik_ev+$ik_konuk<1.5) { return "1"; }else
      if($tur=="Misafir ve 1.5 Alt"  && $ik_ev<$ik_konuk && $ik_ev+$ik_konuk<1.5) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="2. Yarı Sonucu ve 2. Yarı İki Takım da Gol Atar") {
      if($tur=="Misafir / Evet"   && $ik_ev !=0 && $ik_konuk!=0 && $ik_ev<$ik_konuk) { return "1"; }else 
      if($tur=="Ev Sahibi / Evet"   && $ik_ev!=0 && $ik_konuk!=0 && $ik_ev>$ik_konuk){ return "1"; }else
      if($tur=="Beraberlik / Evet"  && $ik_ev !=0 && $ik_konuk!=0 && $ik_ev==$ik_konuk) { return "1"; }else
      if($tur=="Misafir / Hayır"  && ($ik_ev ==0 || $ik_konuk==0) && $ik_ev<$ik_konuk) { return "1"; }else
      if($tur=="Ev Sahibi / Hayır"  && ($ik_ev ==0 || $ik_konuk==0) && $ik_ev>$ik_konuk) { return "1"; }else
      if($tur=="Beraberlik / Hayır" && ($ik_ev ==0 || $ik_konuk==0) && $ik_ev==$ik_konuk) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Toplam Gol") {
      if($tur=="Gol Olmaz" && $ik_ev+$ik_konuk==0) { return "1"; }else
      if($tur=="1 Gol" && $ik_ev+$ik_konuk==1) { return "1"; }else
      if($tur=="2 ve Üzeri" && $ik_ev+$ik_konuk>=2) { return "1"; }
     else { return "2"; }
  }

  else if($grup=="2. Yarı Alt / Üst") {
      if($tur=="0.5 Üst" && $ik_ev+$ik_konuk>0.5) { return "1"; }else
      if($tur=="0.5 Alt" && $ik_ev+$ik_konuk<0.5) { return "1"; }else
      if($tur=="1.5 Üst" && $ik_ev+$ik_konuk>1.5) { return "1"; }else
      if($tur=="1.5 Alt" && $ik_ev+$ik_konuk<1.5) { return "1"; }else
      if($tur=="2.5 Üst" && $ik_ev+$ik_konuk>2.5) { return "1"; }else
      if($tur=="2.5 Alt" && $ik_ev+$ik_konuk<2.5) { return "1"; }else
      if($tur=="3.5 Üst" && $ik_ev+$ik_konuk>3.5) { return "1"; }else
      if($tur=="3.5 Alt" && $ik_ev+$ik_konuk<3.5) { return "1"; }else
      if($tur=="4.5 Üst" && $ik_ev+$ik_konuk>4.5) { return "1"; }else
      if($tur=="4.5 Alt" && $ik_ev+$ik_konuk<4.5) { return "1"; }else
      if($tur=="5.5 Üst" && $ik_ev+$ik_konuk>5.5) { return "1"; }else
      if($tur=="5.5 Alt" && $ik_ev+$ik_konuk<5.5) { return "1"; }else
      if($tur=="6.5 Üst" && $ik_ev+$ik_konuk>6.5) { return "1"; }else
      if($tur=="6.5 Alt" && $ik_ev+$ik_konuk<6.5) { return "1"; }else
      if($tur=="7.5 Üst" && $ik_ev+$ik_konuk>7.5) { return "1"; }else
      if($tur=="7.5 Alt" && $ik_ev+$ik_konuk<7.5) { return "1"; }else
      if($tur=="8.5 Üst" && $ik_ev+$ik_konuk>8.5) { return "1"; }else
      if($tur=="8.5 Alt" && $ik_ev+$ik_konuk<8.5) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Kaç Gol Olur") {
      if($tur=="1 veya 2" && $ik_ev+$ik_konuk<3) { return "1"; }else
      if($tur=="1, 2, veya 3" && $ik_ev+$ik_konuk<4) { return "1"; }else
      if($tur=="2 veya 3" && $ik_ev+$ik_konuk>1 && $ik_ev+$ik_konuk<4) { return "1"; }else
      if($tur=="4 ve Üzeri" && $ik_ev+$ik_konuk>3) { return "1"; }else
      if($tur=="Gol Olmaz" && $ik_ev+$ik_konuk==0) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Ev Sahibi Alt / Üst") {
      if($tur=="0.5 Alt"  && $ik_ev<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $ik_ev>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $ik_ev<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $ik_ev>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $ik_ev<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $ik_ev>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $ik_ev<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $ik_ev>3.5){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Ev Sahibi Gol Yemez") {
      if($tur=="Gol Yemez"  && $ik_konuk==0) { return "1"; }else 
      if($tur=="Gol Yer"    && $iy_konuk>0){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarı Misafir Alt / Üst") {
      if($tur=="0.5 Alt"  && $ik_konuk<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $ik_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $ik_konuk<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $ik_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $ik_konuk<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $ik_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $ik_konuk<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $ik_konuk>3.5){ return "1"; }
      else { return "2"; }
}

  else if($grup=="2. Yarı Misafir Gol Yemez") {
      if($tur=="Gol Yemez"  && $ik_ev==0) { return "1"; }else 
      if($tur=="Gol Yer"  && $ik_ev>0){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="2. Yarıda İki Takım da Gol Atar") {
      if($tur=="Hayır" && $ik_ev==0 && $ik_konuk==0) { return "1"; }else
      if($tur=="Evet" && $ik_ev!=0 && $ik_konuk!=0) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="2. Yarı Tek / Çift") {
      if($tur=="Çift" && $ik_toplamgol%2==0) { return "1"; }else
      if($tur=="Tek" && $ik_toplamgol%2!=0) { return "1"; }

      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Gol Sayısı") {
      if($tur=="1 Gol"  && $ft_ev==1) { return "1"; }else 
      if($tur=="2 Gol"  && $ft_ev==2){ return "1"; }else
      if($tur=="Gol Atamaz"  && $ft_ev==0) { return "1"; }else 
      if($tur=="3 ve Üzeri"  && $ft_ev>=3){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Alt / Üst") {
      if($tur=="0.5 Alt"  && $ft_ev<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $ft_ev>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $ft_ev<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $ft_ev>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $ft_ev<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $ft_ev>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $ft_ev<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $ft_ev>3.5){ return "1"; }
      else { return "2"; }
}

  else if($grup=="Ev Sahibi Kaç Gol Atar") {
      if($tur=="Gol Atamaz"  && $ft_ev==0) { return "1"; }else 
      if($tur=="1 veya 2"  && $ft_ev<3) { return "1"; }else 
      if($tur=="1, 2, veya 3"  && $ft_ev<4) { return "1"; }else 
      if($tur=="2 veya 3"  && $ft_ev>1 && $ft_ev<4) { return "1"; }else 
      if($tur=="4 ve Üzeri"  && $ft_ev>3) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Gol Yemez") {
      if($tur=="Gol Yemez"  && $ft_konuk==0) { return "1"; }else 
      if($tur=="Gol Yer"    && $ft_konuk>0){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Gol Yemez") {
      if($tur=="Gol Yemez"  && $ft_ev==0) { return "1"; }else 
      if($tur=="Gol Yer"    && $ft_ev>0){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Gol Yemeden Kazanır") {
      if($tur=="Evet"   && $ft_ev>$ft_konuk && $ft_konuk==0) { return "1"; }else
      if($tur=="Hayır"  && $ft_ev>$ft_konuk && $ft_konuk!=0) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Ev Sahibi En Az Bir Yarıyı Kazanır") {
      if($tur=="Evet"   && ($ik_ev>$ik_konuk || $iy_ev>$iy_konuk )) { return "1"; }else
      if($tur=="Hayır"  && $ik_ev<=$ik_konuk && $iy_ev<=$iy_konuk   ) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Ev Sahibi Her İki Yarıyı da Kazanır") {
      if($tur=="Evet"   && ($ik_ev>$ik_konuk && $iy_ev>$iy_konuk )) { return "1"; }else
      if($tur=="Hayır"  && ($ik_ev<=$ik_konuk || $iy_ev<=$iy_konuk)) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Ev Sahibi Her İki Yarıda da Gol Atar") {
      if($tur=="Evet"   && ($ik_ev>0 && $iy_ev>0)) { return "1"; }else
      if($tur=="Hayır"  && ($ik_ev<=0 || $iy_ev<=0)) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Hangi Yarı Daha Çok Gol Atar") {
      if($tur=="1. Yarı" && $iy_ev>$ik_ev) { return "1-"; }else 
      if($tur=="Eşit" && $iy_ev==$ik_ev){ return "1"; }else
      if($tur=="2. Yarı" && $iy_ev<$ik_ev){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Ev Sahibi Tek / Çift") {
      if($tur=="Çift" && $ft_ev%2==0) { return "1"; }else
      if($tur=="Tek"  &&  $ft_ev%2!=0) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Gol Sayısı") {
      if($tur=="1 Gol"  && $ft_konuk==1) { return "1"; }else 
      if($tur=="2 Gol"  && $ft_konuk==2){ return "1"; }else
      if($tur=="Gol Atamaz"  && $ft_konuk==0) { return "1"; }else 
      if($tur=="3 ve Üzeri"  && $ft_konuk>=3){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Alt / Üst") {
      if($tur=="0.5 Alt"  && $ft_konuk<0.5) { return "1"; }else 
      if($tur=="0.5 Üst"  && $ft_konuk>0.5){ return "1"; }else
      if($tur=="1.5 Alt"  && $ft_konuk<1.5) { return "1"; }else 
      if($tur=="1.5 Üst"  && $ft_konuk>1.5){ return "1"; }else
      if($tur=="2.5 Alt"  && $ft_konuk<2.5) { return "1"; }else 
      if($tur=="2.5 Üst"  && $ft_konuk>2.5){ return "1"; }else
      if($tur=="3.5 Alt"  && $ft_konuk<3.5) { return "1"; }else 
      if($tur=="3.5 Üst"  && $ft_konuk>3.5){ return "1"; }
      else { return "2"; }
}

  else if($grup=="Misafir Kaç Gol Atar") {
      if($tur=="Gol Atamaz"  && $ft_konuk==0) { return "1"; }else 
      if($tur=="1 veya 2"  && $ft_konuk<3) { return "1"; }else 
      if($tur=="1, 2, veya 3"  && $ft_konuk<4) { return "1"; }else 
      if($tur=="2 veya 3"  && $ft_konuk>1 && $ft_ev<4) { return "1"; }else 
      if($tur=="4 ve Üzeri"  && $ft_konuk>3) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Gol Yemeden Kazanır") {
      if($tur=="Evet"   && $ft_ev<$ft_konuk && $ft_ev==0) { return "1"; }else
      if($tur=="Hayır"  && $ft_ev<$ft_konuk && $ft_ev!=0) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Misafir En Az Bir Yarıyı Kazanır") {
      if($tur=="Evet"   && ($ik_ev<$ik_konuk || $iy_ev<$iy_konuk )) { return "1"; }else
      if($tur=="Hayır"  && $ik_ev>=$ik_konuk && $iy_ev>=$iy_konuk   ) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Misafir Her İki Yarıyı da Kazanır") {
      if($tur=="Evet"   && ($ik_konuk>$ik_ev && $iy_konuk>$iy_ev )) { return "1"; }else
      if($tur=="Hayır"  && ($ik_konuk<=$ik_ev || $iy_konuk<=$iy_ev)) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="Misafir Her İki Yarıda da Gol Atar") {
      if($tur=="Evet"   && ($ik_konuk>0 && $iy_konuk>0)) { return "1"; }else
      if($tur=="Hayır"  && ($ik_konuk<=0 || $iy_konuk<=0)) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Hangi Yarı Daha Çok Gol Atar") {
      if($tur=="1. Yarı" && $iy_konuk>$ik_konuk) { return "1"; }else 
      if($tur=="Eşit" && $iy_konuk==$ik_konuk){ return "1"; }else
      if($tur=="2. Yarı" && $iy_konuk<$ik_konuk){ return "1"; }
      else { return "2"; }
  }

  else if($grup=="Misafir Tek / Çift") {
      if($tur=="Çift" && $ft_konuk%2==0) { return "1"; }else
      if($tur=="Tek"  &&  $ft_konuk%2!=0) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="İlk Yarı / Maç Sonucu ve Alt / Üst") {
      if($tur=="1 / 1 ve 1.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<1.5) { return "1"; }else 
      if($tur=="1 / 1 ve 1.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>1.5) { return "1"; }else 
      if($tur=="X / 1 ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="X / 1 ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="X / X ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="X / X ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="X / 2 ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="X / 2 ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="2 / 2 ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="2 / 2 ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="1 / 2 ve 1.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="1 / 2 ve 1.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="2 / 1 ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="2 / 1 ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>1.5) { return "1"; }else
      if($tur=="2 / X ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<1.5) { return "1"; }else
      if($tur=="2 / X ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>1.5) { return "1"; }else


      if($tur=="1 / 1 ve 2.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<2.5) { return "1"; }else 
      if($tur=="1 / 1 ve 2.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>2.5) { return "1"; }else 
      if($tur=="X / 1 ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="X / 1 ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="X / X ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="X / X ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="X / 2 ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="X / 2 ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="2 / 2 ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="2 / 2 ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="1 / 2 ve 2.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="1 / 2 ve 2.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="2 / 1 ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="2 / 1 ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>2.5) { return "1"; }else
      if($tur=="2 / X ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<2.5) { return "1"; }else
      if($tur=="2 / X ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>2.5) { return "1"; }else


      if($tur=="1 / 1 ve 3.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<3.5) { return "1"; }else 
      if($tur=="1 / 1 ve 3.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>3.5) { return "1"; }else 
      if($tur=="X / 1 ve 3.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="X / 1 ve 3.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="X / X ve 3.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="X / X ve 3.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="X / 2 ve 3.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="X / 2 ve 3.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="2 / 2 ve 3.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="2 / 2 ve 3.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="1 / 2 ve 3.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="1 / 2 ve 3.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="2 / 1 ve 3.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="2 / 1 ve 3.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      if($tur=="2 / X ve 3.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<3.5) { return "1"; }else
      if($tur=="2 / X ve 3.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>3.5) { return "1"; }else
      
      
      if($tur=="1 / 1 ve 4.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<4.5) { return "1"; }else 
      if($tur=="1 / 1 ve 4.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>4.5) { return "1"; }else 
      if($tur=="X / 1 ve 4.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="X / 1 ve 4.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="X / X ve 4.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="X / X ve 4.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="X / 2 ve 4.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="X / 2 ve 4.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="2 / 2 ve 4.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="2 / 2 ve 4.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="1 / 2 ve 4.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="1 / 2 ve 4.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="2 / 1 ve 4.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="2 / 1 ve 4.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $toplam_gol>4.5) { return "1"; }else
      if($tur=="2 / X ve 4.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol<4.5) { return "1"; }else
      if($tur=="2 / X ve 4.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $toplam_gol>4.5) { return "1"; }     

      else { return "2"; }
 
 }

  else if($grup=="İlk Yarı / Maç Sonucu ve 1. Yarı Alt / Üst") {

      if($tur=="1 / 1 ve 0.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else 
      if($tur=="1 / 1 ve 0.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else 
      if($tur=="X / 1 ve 0.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="X / 1 ve 0.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="X / X ve 0.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="X / X ve 0.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="X / 2 ve 0.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="X / 2 ve 0.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="2 / 2 ve 0.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="2 / 2 ve 0.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="1 / 2 ve 0.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="1 / 2 ve 0.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="2 / 1 ve 0.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="2 / 1 ve 0.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else
      if($tur=="2 / X ve 0.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<0.5) { return "1"; }else
      if($tur=="2 / X ve 0.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>0.5) { return "1"; }else

      if($tur=="1 / 1 ve 1.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else 
      if($tur=="1 / 1 ve 1.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else 
      if($tur=="X / 1 ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="X / 1 ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="X / X ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="X / X ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="X / 2 ve 1.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="X / 2 ve 1.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="2 / 2 ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="2 / 2 ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="1 / 2 ve 1.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="1 / 2 ve 1.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="2 / 1 ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="2 / 1 ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else
      if($tur=="2 / X ve 1.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<1.5) { return "1"; }else
      if($tur=="2 / X ve 1.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>1.5) { return "1"; }else


      if($tur=="1 / 1 ve 2.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else 
      if($tur=="1 / 1 ve 2.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else 
      if($tur=="X / 1 ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="X / 1 ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="X / X ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="X / X ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="X / 2 ve 2.5 Alt"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="X / 2 ve 2.5 Üst"  && $iy_ev==$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="2 / 2 ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="2 / 2 ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="1 / 2 ve 2.5 Alt"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="1 / 2 ve 2.5 Üst"  && $iy_ev>$iy_konuk && $ft_ev<$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="2 / 1 ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="2 / 1 ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev>$ft_konuk && $iy_toplamgol>2.5) { return "1"; }else
      if($tur=="2 / X ve 2.5 Alt"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol<2.5) { return "1"; }else
      if($tur=="2 / X ve 2.5 Üst"  && $iy_ev<$iy_konuk && $ft_ev==$ft_konuk && $iy_toplamgol>2.5) { return "1"; }

else { return "2"; }
 }

  else if($grup=="Multi Skor") {
      if($tur=="Ev Sahibi 1:0,2:0 veya 3:0 kazanır" && ($ft_ev==1 || $ft_ev==2 || $ft_ev==3) && $ft_konuk==0) { return "1"; }else 
      if($tur=="Misafir 0:1,0:2 veya 0:3 kazanır" && ($ft_konuk==1 || $ft_konuk==2 || $ft_konuk==3) && $ft_ev==0) { return "1"; }else 
      if($tur=="Ev Sahibi 4:0,5:0 veya 6:0 kazanır" && ($ft_ev==4 || $ft_ev==5 || $ft_ev==6) && $ft_konuk==0) { return "1"; }else 
      if($tur=="Misafir 0:4,0:5 veya 0:6 kazanır" && ($ft_konuk==4 || $ft_konuk==5 || $ft_konuk==6) && $ft_ev==0) { return "1"; }else 
      if($tur=="Ev Sahibi 2:1,3:1 veya 4:1 kazanır" && ($ft_ev==2 || $ft_ev==3 || $ft_ev==4) && $ft_konuk==1) { return "1"; }else 
      if($tur=="Misafir 1:2,1:3 veya 1:4 kazanır" && ($ft_konuk==2 || $ft_konuk==3 || $ft_konuk==4) && $ft_ev==1) { return "1"; }else 
      if($tur=="Ev Sahibi 3:2,4:2,4:3 veya 5:1 kazanır" && (($ft_ev==3 && $ft_konuk==2) || ($ft_ev==4 && $ft_konuk==2) || ($ft_ev==4 && $ft_konuk==3) || ($ft_ev==5 && $ft_konuk==1)   )) { return "1"; }else 
      if($tur=="Misafir 2:3,2:4,3:4 veya 1:5 kazanır" && (($ft_ev==2 && $ft_konuk==3) || ($ft_ev==2 && $ft_konuk==4) || ($ft_ev==3 && $ft_konuk==4) || ($ft_ev==1 && $ft_konuk==5)   )) { return "1"; }else       
      if($tur=="Ev Sahibi başka bir skorla kazanır" && $ft_ev>$ft_konuk) { return "1"; }else 
      if($tur=="Misafir başka bir skorla kazanır" && $ft_ev<$ft_konuk) { return "1"; }
      else { return "2"; }
  }

  else if($grup=="1. Yarı Skoru") {
      if($tur=="0:5" && $iy_ev==0 && $iy_konuk==5) { return "1"; }else
      if($tur=="0:4" && $iy_ev==0 && $iy_konuk==4) { return "1"; }else
      if($tur=="1:3" && $iy_ev==1 && $iy_konuk==3) { return "1"; }else
      if($tur=="0:3" && $iy_ev==0 && $iy_konuk==3) { return "1"; }else
      if($tur=="1:2" && $iy_ev==1 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:2" && $iy_ev==0 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:1" && $iy_ev==0 && $iy_konuk==1) { return "1"; }else
      if($tur=="1:1" && $iy_ev==1 && $iy_konuk==1) { return "1"; }else
      if($tur=="2:2" && $iy_ev==2 && $iy_konuk==2) { return "1"; }else
      if($tur=="0:0" && $iy_ev==0 && $iy_konuk==0) { return "1"; }else
      if($tur=="1:0" && $iy_ev==1 && $iy_konuk==0) { return "1"; }else
      if($tur=="5:0" && $iy_ev==5 && $iy_konuk==0) { return "1"; }else
      if($tur=="4:0" && $iy_ev==4 && $iy_konuk==0) { return "1"; }else
      if($tur=="3:1" && $iy_ev==3 && $iy_konuk==1) { return "1"; }else
      if($tur=="3:0" && $iy_ev==3 && $iy_konuk==0) { return "1"; }else
      if($tur=="2:1" && $iy_ev==2 && $iy_konuk==1) { return "1"; }else
      if($tur=="2:0" && $iy_ev==2 && $iy_konuk==0) { return "1"; }
      
      else { return "2"; }
  }

  else if($grup=="Maç Skoru") {
      if($tur=="0:6" && $ft_ev==0 && $ft_konuk==6) { return "1"; }else 
      if($tur=="1:5" && $ft_ev==1 && $ft_konuk==5){ return "1"; }else
      if($tur=="0:5" && $ft_ev==0 && $ft_konuk==5) { return "1"; }else
      if($tur=="2:4" && $ft_ev==2 && $ft_konuk==4) { return "1"; }else
      if($tur=="1:4" && $ft_ev==1 && $ft_konuk==4) { return "1"; }else
      if($tur=="0:4" && $ft_ev==0 && $ft_konuk==4) { return "1"; }else
      if($tur=="2:3" && $ft_ev==2 && $ft_konuk==3) { return "1"; }else
      if($tur=="1:3" && $ft_ev==1 && $ft_konuk==3) { return "1"; }else
      if($tur=="0:3" && $ft_ev==0 && $ft_konuk==3) { return "1"; }else
      if($tur=="1:2" && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0:2" && $ft_ev==0 && $ft_konuk==2) { return "1"; }else
      if($tur=="0:1" && $ft_ev==0 && $ft_konuk==1) { return "1"; }else
      if($tur=="3:3" && $ft_ev==3 && $ft_konuk==3) { return "1"; }else
      if($tur=="2:2" && $ft_ev==2 && $ft_konuk==2) { return "1"; }else
      if($tur=="1:1" && $ft_ev==1 && $ft_konuk==1) { return "1"; }else
      if($tur=="0:0" && $ft_ev==0 && $ft_konuk==0) { return "1"; }else
      if($tur=="6:0" && $ft_ev==6 && $ft_konuk==0) { return "1"; }else
      if($tur=="5:1" && $ft_ev==5 && $ft_konuk==1) { return "1"; }else
      if($tur=="4:2" && $ft_ev==4 && $ft_konuk==2) { return "1"; }else
      if($tur=="3:2" && $ft_ev==3 && $ft_konuk==2) { return "1"; }else
      if($tur=="3:1" && $ft_ev==3 && $ft_konuk==1) { return "1"; }else
      if($tur=="3:0" && $ft_ev==3 && $ft_konuk==0) { return "1"; }else
      if($tur=="2:1" && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="2:0" && $ft_ev==2 && $ft_konuk==0) { return "1"; }else
      if($tur=="1:0" && $ft_ev==1 && $ft_konuk==0) { return "1"; }else
      if($tur=="4:1" && $ft_ev==4 && $ft_konuk==1) { return "1"; }else
      if($tur=="4:0" && $ft_ev==4 && $ft_konuk==0) { return "1"; }
      else { return "2"; }
  }



  else if($grup=="İlk Yarı / Maç Sonucu Skorları") {
      if($tur=="0-3 / 0-3" && $iy_ev==0 && $iy_konuk==3 && $ft_ev==0 && $ft_konuk==3) { return "1"; }else
      if($tur=="1-2 / 1-2" && $iy_ev==1 && $iy_konuk==2 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-2 / 0-3" && $iy_ev==0 && $iy_konuk==2 && $ft_ev==0 && $ft_konuk==3) { return "1"; }else
      if($tur=="0-2 / 1-2" && $iy_ev==0 && $iy_konuk==2 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-2 / 0-2" && $iy_ev==0 && $iy_konuk==2 && $ft_ev==0 && $ft_konuk==2) { return "1"; }else
      if($tur=="1-1 / 1-2" && $iy_ev==1 && $iy_konuk==1 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-1 / 2-1" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-1 / 1-1" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==1 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-1 / 0-3" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==0 && $ft_konuk==3) { return "1"; }else
      if($tur=="0-1 / 1-2" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-1 / 0-2" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==0 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-1 / 0-1" && $iy_ev==0 && $iy_konuk==1 && $ft_ev==0 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-0 / 0-3" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==0 && $ft_konuk==3) { return "1"; }else
      if($tur=="0-0 / 1-2" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-0 / 1-2" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-0 / 0-2" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==0 && $ft_konuk==2) { return "1"; }else
      if($tur=="0-0 / 0-1" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==0 && $ft_konuk==1) { return "1"; }else
      if($tur=="4 ve Üzeri / 4 ve Üzeri" && $iy_ev+$iy_konuk>=4 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="0-3 / 4 ve Üzeri" && $iy_ev==0 && $iy_konuk==3 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="3-0 / 4 ve Üzeri" && $iy_ev==3 && $iy_konuk==0 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="0-2 / 4 ve Üzeri" && $iy_ev==0 && $iy_konuk==2 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="2-0 / 4 ve Üzeri" && $iy_ev==2 && $iy_konuk==0 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="1-2 / 4 ve Üzeri" && $iy_ev==1 && $iy_konuk==2 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="2-1 / 4 ve Üzeri" && $iy_ev==2 && $iy_konuk==1 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="1-1 / 4 ve Üzeri" && $iy_ev==1 && $iy_konuk==1 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="0-1 / 4 ve Üzeri" && $iy_ev==0 && $iy_konuk==1 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="1-0 / 4 ve Üzeri" && $iy_ev==1 && $iy_konuk==0 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="0-0 / 4 ve Üzeri" && $iy_ev==0 && $iy_konuk==0 && $ft_ev+$ft_konuk>=4) { return "1"; }else
      if($tur=="1-1 / 1-1" && $iy_ev==1 && $iy_konuk==1 && $ft_ev==1 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-0 / 1-1" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-0 / 0-0" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==0 && $ft_konuk==0) { return "1"; }else
      if($tur=="3-0 / 3-0" && $iy_ev==3 && $iy_konuk==0 && $ft_ev==3 && $ft_konuk==0) { return "1"; }else
      if($tur=="2-1 / 2-1" && $iy_ev==2 && $iy_konuk==1 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="2-0 / 3-0" && $iy_ev==2 && $iy_konuk==0 && $ft_ev==3 && $ft_konuk==0) { return "1"; }else
      if($tur=="2-0 / 2-1" && $iy_ev==2 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="2-0 / 2-0" && $iy_ev==2 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==0) { return "1"; }else
      if($tur=="1-1 / 2-1" && $iy_ev==1 && $iy_konuk==1 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="1-0 / 1-2" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==2) { return "1"; }else
      if($tur=="1-0 / 1-1" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==1) { return "1"; }else
      if($tur=="1-0 / 3-0" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==3 && $ft_konuk==0) { return "1"; }else
      if($tur=="1-0 / 2-1" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="1-0 / 2-0" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==0) { return "1"; }else
      if($tur=="1-0 / 1-0" && $iy_ev==1 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==0) { return "1"; }else
      if($tur=="0-0 / 3-0" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==3 && $ft_konuk==0) { return "1"; }else
      if($tur=="0-0 / 2-1" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==1) { return "1"; }else
      if($tur=="0-0 / 2-0" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==2 && $ft_konuk==0) { return "1"; }else
      if($tur=="0-0 / 1-0" && $iy_ev==0 && $iy_konuk==0 && $ft_ev==1 && $ft_konuk==0) { return "1"; }
      else { return "2"; }
  }
  
  
  else if($grup=="2. Yarı Handikap 1:0") {
      if($tur=="Ev Sahibi"  && $ik_ev+1>$ik_konuk) { return "1"; }else 
      if($tur=="Beraberlik" && $ik_ev+1==$ik_konuk){ return "1"; }else
      if($tur=="Misafir"  && $ik_ev+1<$ik_konuk) { return "1"; }
      else { return "2"; }
  }

 else if($grup=="İlk 10 Dakika Maç Sonucu") {

$ev_sahibi_gol=self::gol_sayilari($mac_id,1,0,11);
$misafir_gol=self::gol_sayilari($mac_id,2,0,11);
      if($tur=="Ev Sahibi"  && $ev_sahibi_gol>$misafir_gol) { return "1"; }else 
      if($tur=="Beraberlik" && $ev_sahibi_gol==$misafir_gol){ return "1"; }else
      if($tur=="Misafir"  && $ev_sahibi_gol<$misafir_gol) { return "1"; }
      else { return "2"; }
  }
 

 else if($grup=="İlk Gol Zamanı ( 10 Dk )") {

$ilk_gol_zamani=self::ilk_gol_zamani($mac_id);

      if($tur=="1 - 10 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=10) { return "1"; }else 
      if($tur=="11 - 20 Arası" && $ilk_gol_zamani>=11 && $ilk_gol_zamani<=20){ return "1"; }else
      if($tur=="21 - 30 Arası"  && $ilk_gol_zamani>=21 && $ilk_gol_zamani<=30) { return "1"; }else
      if($tur=="31 - 40 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=40) { return "1"; }else
      if($tur=="41 - 50 Arası"  && $ilk_gol_zamani>=41 && $ilk_gol_zamani<=50) { return "1"; }else
      if($tur=="51 - 60 Arası"  && $ilk_gol_zamani>=51 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 70 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=70) { return "1"; }else
      if($tur=="71 - 80 Arası"  && $ilk_gol_zamani>=71 && $ilk_gol_zamani<=80) { return "1"; }else
      if($tur=="81 - 90+ Arası"  && $ilk_gol_zamani>=81 ) { return "1"; }else
      { return "2"; }
  }
  
 else if($grup=="İlk Gol Zamanı ( 15 Dk )") {

$ilk_gol_zamani=self::ilk_gol_zamani($mac_id);

      if($tur=="1 - 15 Arası"  && $ilk_gol_zamani>=1 && $ilk_gol_zamani<=15) { return "1"; }else 
      if($tur=="16 - 30 Arası" && $ilk_gol_zamani>=16 && $ilk_gol_zamani<=30){ return "1"; }else
      if($tur=="31 - 45 Arası"  && $ilk_gol_zamani>=31 && $ilk_gol_zamani<=45) { return "1"; }else
      if($tur=="46 - 60 Arası"  && $ilk_gol_zamani>=46 && $ilk_gol_zamani<=60) { return "1"; }else
      if($tur=="61 - 75 Arası"  && $ilk_gol_zamani>=61 && $ilk_gol_zamani<=75) { return "1"; }else
      if($tur=="76 - 90+ Arası"  && $ilk_gol_zamani>=76) { return "1"; }else
     
      { return "2"; }
  }

 else if($grup=="Korner Sayısı") {

$toplam_korner_sayisi=self::korner_sayisi($mac_id,0,150);

      if($tur=="4.5 Alt"  && $toplam_korner_sayisi<4.5) { return "1"; }else 
      if($tur=="4.5 Üst" && $toplam_korner_sayisi>4.5){ return "1"; }else

      if($tur=="5.5 Alt"  && $toplam_korner_sayisi<5.5) { return "1"; }else 
      if($tur=="5.5 Üst" && $toplam_korner_sayisi>5.5){ return "1"; }else

      if($tur=="6.5 Alt"  && $toplam_korner_sayisi<6.5) { return "1"; }else 
      if($tur=="6.5 Üst" && $toplam_korner_sayisi>6.5){ return "1"; }else

      if($tur=="7.5 Alt"  && $toplam_korner_sayisi<7.5) { return "1"; }else 
      if($tur=="7.5 Üst" && $toplam_korner_sayisi>7.5){ return "1"; }else

      if($tur=="8.5 Alt"  && $toplam_korner_sayisi<8.5) { return "1"; }else 
      if($tur=="8.5 Üst" && $toplam_korner_sayisi>8.5){ return "1"; }else

      if($tur=="9.5 Alt"  && $toplam_korner_sayisi<9.5) { return "1"; }else 
      if($tur=="9.5 Üst" && $toplam_korner_sayisi>9.5){ return "1"; }else

      if($tur=="10.5 Alt"  && $toplam_korner_sayisi<10.5) { return "1"; }else 
      if($tur=="10.5 Üst" && $toplam_korner_sayisi>10.5){ return "1"; }else

      if($tur=="11.5 Alt"  && $toplam_korner_sayisi<11.5) { return "1"; }else 
      if($tur=="11.5 Üst" && $toplam_korner_sayisi>11.5){ return "1"; }else

      if($tur=="12.5 Alt"  && $toplam_korner_sayisi<12.5) { return "1"; }else 
      if($tur=="12.5 Üst" && $toplam_korner_sayisi>12.5){ return "1"; }else

      if($tur=="13.5 Alt"  && $toplam_korner_sayisi<13.5) { return "1"; }else 
      if($tur=="13.5 Üst" && $toplam_korner_sayisi>13.5){ return "1"; }else

      if($tur=="14.5 Alt"  && $toplam_korner_sayisi<14.5) { return "1"; }else 
      if($tur=="14.5 Üst" && $toplam_korner_sayisi>14.5){ return "1"; }else
      
     
      { return "2"; }
  }


 else if($grup=="1. Yarı Korner Sayısı") {

$toplam_korner_sayisi=self::korner_sayisi($mac_id,0,45);

      if($tur=="4.5 Alt"  && $toplam_korner_sayisi<4.5) { return "1"; }else 
      if($tur=="4.5 Üst" && $toplam_korner_sayisi>4.5){ return "1"; }else

      if($tur=="5.5 Alt"  && $toplam_korner_sayisi<5.5) { return "1"; }else 
      if($tur=="5.5 Üst" && $toplam_korner_sayisi>5.5){ return "1"; }else

      if($tur=="6.5 Alt"  && $toplam_korner_sayisi<6.5) { return "1"; }else 
      if($tur=="6.5 Üst" && $toplam_korner_sayisi>6.5){ return "1"; }else

      if($tur=="7.5 Alt"  && $toplam_korner_sayisi<7.5) { return "1"; }else 
      if($tur=="7.5 Üst" && $toplam_korner_sayisi>7.5){ return "1"; }else

      if($tur=="8.5 Alt"  && $toplam_korner_sayisi<8.5) { return "1"; }else 
      if($tur=="8.5 Üst" && $toplam_korner_sayisi>8.5){ return "1"; }else

      if($tur=="9.5 Alt"  && $toplam_korner_sayisi<9.5) { return "1"; }else 
      if($tur=="9.5 Üst" && $toplam_korner_sayisi>9.5){ return "1"; }else

      if($tur=="10.5 Alt"  && $toplam_korner_sayisi<10.5) { return "1"; }else 
      if($tur=="10.5 Üst" && $toplam_korner_sayisi>10.5){ return "1"; }else

      if($tur=="11.5 Alt"  && $toplam_korner_sayisi<11.5) { return "1"; }else 
      if($tur=="11.5 Üst" && $toplam_korner_sayisi>11.5){ return "1"; }else

      if($tur=="12.5 Alt"  && $toplam_korner_sayisi<12.5) { return "1"; }else 
      if($tur=="12.5 Üst" && $toplam_korner_sayisi>12.5){ return "1"; }else

      if($tur=="13.5 Alt"  && $toplam_korner_sayisi<13.5) { return "1"; }else 
      if($tur=="13.5 Üst" && $toplam_korner_sayisi>13.5){ return "1"; }else

      if($tur=="14.5 Alt"  && $toplam_korner_sayisi<14.5) { return "1"; }else 
      if($tur=="14.5 Üst" && $toplam_korner_sayisi>14.5){ return "1"; }else
      
     
      { return "2"; }
  }



else if($grup=="Korner Sayı Aralığı") {

$toplam_korner_sayisi=self::korner_sayisi($mac_id,0,150);

      if($tur=="0-8 Korner"  && $toplam_korner_sayisi>=0 && $toplam_korner_sayisi<=8) { return "1"; }else 
      if($tur=="9-11 Korner" && $toplam_korner_sayisi>=9 && $toplam_korner_sayisi<=11){ return "1"; }else
      if($tur=="12 ve Üzeri"  && $toplam_korner_sayisi>=12) { return "1"; }else 
     
      { return "2"; }
  }




else if($grup=="Korner Handikap") {

$ev_sahibi_korner_sayisi=self::takim_korner_sayisi($mac_id,1,0,150);
$misafir_korner_sayisi=self::takim_korner_sayisi($mac_id,2,0,150);

      if($tur=="Ev Sahibi +0.5"  && ($ev_sahibi_korner_sayisi+0.5)>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Ev Sahibi +1.5"  && ($ev_sahibi_korner_sayisi+1.5)>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Ev Sahibi +2.5" &&  ($ev_sahibi_korner_sayisi+2.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +3.5" &&  ($ev_sahibi_korner_sayisi+3.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +4.5" &&  ($ev_sahibi_korner_sayisi+4.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +5.5" &&  ($ev_sahibi_korner_sayisi+5.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +6.5" &&  ($ev_sahibi_korner_sayisi+6.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +7.5" &&  ($ev_sahibi_korner_sayisi+7.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi +8.5" &&  ($ev_sahibi_korner_sayisi+8.5)>$misafir_korner_sayisi ){ return "1"; }else

      if($tur=="Ev Sahibi -0.5"  && ($ev_sahibi_korner_sayisi-0.5)>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Ev Sahibi -1.5"  && ($ev_sahibi_korner_sayisi-1.5)>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Ev Sahibi -2.5" &&  ($ev_sahibi_korner_sayisi-2.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -3.5" &&  ($ev_sahibi_korner_sayisi-3.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -4.5" &&  ($ev_sahibi_korner_sayisi-4.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -5.5" &&  ($ev_sahibi_korner_sayisi-5.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -6.5" &&  ($ev_sahibi_korner_sayisi-6.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -7.5" &&  ($ev_sahibi_korner_sayisi-7.5)>$misafir_korner_sayisi ){ return "1"; }else
      if($tur=="Ev Sahibi -8.5" &&  ($ev_sahibi_korner_sayisi-8.5)>$misafir_korner_sayisi ){ return "1"; }else

      if($tur=="Misafir +0.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+0.5) ){ return "1"; }else
      if($tur=="Misafir +1.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+1.5) ){ return "1"; }else
      if($tur=="Misafir +2.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+2.5) ){ return "1"; }else
      if($tur=="Misafir +3.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+3.5) ){ return "1"; }else
      if($tur=="Misafir +4.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+4.5) ){ return "1"; }else
      if($tur=="Misafir +5.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+5.5) ){ return "1"; }else
      if($tur=="Misafir +6.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+6.5) ){ return "1"; }else
      if($tur=="Misafir +7.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+7.5) ){ return "1"; }else
      if($tur=="Misafir +8.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi+8.5) ){ return "1"; }else

      if($tur=="Misafir -0.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-0.5) ){ return "1"; }else
      if($tur=="Misafir -1.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-1.5) ){ return "1"; }else
      if($tur=="Misafir -2.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-2.5) ){ return "1"; }else
      if($tur=="Misafir -3.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-3.5) ){ return "1"; }else
      if($tur=="Misafir -4.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-4.5) ){ return "1"; }else
      if($tur=="Misafir -5.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-5.5) ){ return "1"; }else
      if($tur=="Misafir -6.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-6.5) ){ return "1"; }else
      if($tur=="Misafir -7.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-7.5) ){ return "1"; }else
      if($tur=="Misafir -8.5" &&  ($ev_sahibi_korner_sayisi)<($misafir_korner_sayisi-8.5) ){ return "1"; }else


     
      { return "2"; }
  }
  



else if($grup=="Hangi Takım Fazla Korner Kullanır") {

$ev_sahibi_korner_sayisi=self::takim_korner_sayisi($mac_id,1,0,150);
$misafir_korner_sayisi=self::takim_korner_sayisi($mac_id,2,0,150);

      if($tur=="Ev Sahibi"  && $ev_sahibi_korner_sayisi>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Eşit"  && $ev_sahibi_korner_sayisi==$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Misafir" &&  $ev_sahibi_korner_sayisi<$misafir_korner_sayisi ){ return "1"; }else
      { return "2"; }
  }

 


else if($grup=="1. Yarı Hangi Takım Fazla Korner Kullanır") {

$ev_sahibi_korner_sayisi=self::takim_korner_sayisi($mac_id,1,0,45);
$misafir_korner_sayisi=self::takim_korner_sayisi($mac_id,2,0,45);

      if($tur=="Ev Sahibi"  && $ev_sahibi_korner_sayisi>$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Eşit"  && $ev_sahibi_korner_sayisi==$misafir_korner_sayisi ) { return "1"; }else 
      if($tur=="Misafir" &&  $ev_sahibi_korner_sayisi<$misafir_korner_sayisi ){ return "1"; }else
      { return "2"; }
  }





else if($grup=="İlk Korner") {

$ilk_korner=self::ilk_korner_atan($mac_id);


      if($tur=="Ev Sahibi"  && $ilk_korner==1 ) { return "1"; }else 
      if($tur=="Korner Olmaz"  && $ilk_korner==0 ) { return "1"; }else 
      if($tur=="Misafir" &&  $ilk_korner==2 ){ return "1"; }else
      { return "2"; }
  }



else if($grup=="Son Korner") {

$ilk_korner=self::son_korner_atan($mac_id);


      if($tur=="Ev Sahibi"  && $ilk_korner==1 ) { return "1"; }else 
      if($tur=="Korner Olmaz"  && $ilk_korner==0 ) { return "1"; }else 
      if($tur=="Misafir" &&  $ilk_korner==2 ){ return "1"; }else
      { return "2"; }
  }



else if($grup=="1. Yarı İlk Korner") {

$ilk_korner=self::birinci_yari_ilk_korner_atan($mac_id);


      if($tur=="Ev Sahibi"  && $ilk_korner==1 ) { return "1"; }else 
      if($tur=="Korner Olmaz"  && $ilk_korner==0 ) { return "1"; }else 
      if($tur=="Misafir" &&  $ilk_korner==2 ){ return "1"; }else
      { return "2"; }
  }



else if($grup=="1. Yarı Son Korner") {

$ilk_korner=self::birinci_yari_son_korner_atan($mac_id);


      if($tur=="Ev Sahibi"  && $ilk_korner==1 ) { return "1"; }else 
      if($tur=="Korner Olmaz"  && $ilk_korner==0 ) { return "1"; }else 
      if($tur=="Misafir" &&  $ilk_korner==2 ){ return "1"; }else
      { return "2"; }
  }





else if($grup=="1. Yarı Korner Tek / Çift") {

$ilk_korner=self::korner_sayisi($mac_id,0,45);


      if($tur=="Çift" && $ilk_korner%2==0 ) { return "1"; }else 
      if($tur=="Tek"  && $ilk_korner%2!=0) { return "1"; }else 
     
      { return "2"; }
  }




  else if($grup=="2. Yarı Skoru") {
      if($tur=="0:0" && $ik_ev==0 && $ik_konuk==0) { return "1"; }else
      if($tur=="0:1" && $ik_ev==0 && $ik_konuk==1) { return "1"; }else
      if($tur=="0:2" && $ik_ev==0 && $ik_konuk==2) { return "1"; }else
      if($tur=="0:3" && $ik_ev==0 && $ik_konuk==3) { return "1"; }else
      if($tur=="0:4" && $ik_ev==0 && $ik_konuk==4) { return "1"; }else
      if($tur=="0:5" && $ik_ev==0 && $ik_konuk==5) { return "1"; }else

      if($tur=="1:0" && $ik_ev==1 && $ik_konuk==0) { return "1"; }else
      if($tur=="1:1" && $ik_ev==1 && $ik_konuk==1) { return "1"; }else
      if($tur=="1:2" && $ik_ev==1 && $ik_konuk==2) { return "1"; }else
      if($tur=="1:3" && $ik_ev==1 && $ik_konuk==3) { return "1"; }else
      if($tur=="2:0" && $ik_ev==2 && $ik_konuk==0) { return "1"; }else 
      if($tur=="2:1" && $ik_ev==2 && $ik_konuk==1) { return "1"; }else
      if($tur=="2:2" && $ik_ev==2 && $ik_konuk==2) { return "1"; }else
      if($tur=="3:0" && $ik_ev==3 && $ik_konuk==0) { return "1"; }else
      if($tur=="3:1" && $ik_ev==3 && $ik_konuk==1) { return "1"; }else
      if($tur=="4:0" && $ik_ev==4 && $ik_konuk==0) { return "1"; }else
      if($tur=="5:0" && $ik_ev==5 && $ik_konuk==0) { return "1"; }else
      { return "2"; }
  }


else if($grup=="2. Yarı İlk Golü Atan Takım") {
$ilk_golu=self::ikinci_yari_ilk_golu_atan($mac_id);


      if($tur=="Ev Sahibi" && $ilk_golu==1 ) { return "1"; }else 
      if($tur=="Gol Olmaz"  && $ilk_golu==0) { return "1"; }else 
      if($tur=="Misafir"  && $ilk_golu==2) { return "1"; }else 
     
      { return "2"; }
  }

  
  else
  {
    return "0";
  }

//fonksiyon sonu
}
   


}

/* End of file model.php */
