<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Account extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

    function __construct()
    {
        parent::__construct();
        $this->load->helper("url");
        $this->load->database();
        $this->load->library("session");
        
       		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
	//	$this->load->library('security');
		$this->load->helper('security');
		$this->load->library('tank_auth');
		$this->lang->load('tank_auth');


    }
    


	public function index()
	{
 parent::__construct();
       User::logged_in();		
$this->load->view('account/account',isset($data) ? $data : NULL);
	}


public function dologin(){


if ($this->tank_auth->is_logged_in()) {									// logged in
			redirect('');

		} elseif ($this->tank_auth->is_logged_in(FALSE)) {						// logged in, not activated
			redirect('/auth/send_again/');

		} else {
			$data['login_by_username'] = ($this->config->item('login_by_username', 'tank_auth') AND
					$this->config->item('use_username', 'tank_auth'));
			$data['login_by_email'] = $this->config->item('login_by_email', 'tank_auth');

			$this->form_validation->set_rules('login', 'Login', 'trim|required|xss_clean');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('remember', 'Remember me', 'integer');

			// Get login for counting attempts to login
			if ($this->config->item('login_count_attempts', 'tank_auth') AND
					($login = $this->input->post('login'))) {
				$login = $this->security->xss_clean($login);
			} else {
				$login = '';
			}

			$data['use_recaptcha'] = $this->config->item('use_recaptcha', 'tank_auth');
			if ($this->tank_auth->is_max_login_attempts_exceeded($login)) {
				if ($data['use_recaptcha'])
					$this->form_validation->set_rules('recaptcha_response_field', 'Confirmation Code', 'trim|xss_clean|required|callback__check_recaptcha');
				else
					$this->form_validation->set_rules('captcha', 'Confirmation Code', 'trim|xss_clean|required|callback__check_captcha');
			}
			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if ($this->tank_auth->login(
						$this->form_validation->set_value('login'),
						$this->form_validation->set_value('password'),
						$this->form_validation->set_value('remember'),
						$data['login_by_username'],
						$data['login_by_email'])) {								// success
				//	redirect('');
					echo("<script>window.location = '/sport';</script>");

				} else {
					$errors = $this->tank_auth->get_error_message();
					if (isset($errors['banned'])) {								// banned user
						$this->_show_message($this->lang->line('auth_message_banned').' '.$errors['banned']);

					} elseif (isset($errors['not_activated'])) {				// not activated user
						//redirect('/auth/send_again/');

						echo "Pasif kullanıcı veya hesap aktif edilmemiş";

					} else {													// fail
						echo "Yanlış Kullanıcı adı veya parola";
						foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
					}
				}
			}
			$data['show_captcha'] = FALSE;
			if ($this->tank_auth->is_max_login_attempts_exceeded($login)) {
				echo "Çok fazla hatalı giriş denemesi. ";
			
			}
//print_r($data);			
		//	$this->load->view('auth/login_form', $data);
		}

	
}

public function dologinout()
	{
		$this->tank_auth->logout();

	//	$this->_show_message($this->lang->line('auth_message_logged_out'));
	}

public function customerinfo(){
User::logged_in();	
$this->load->view('account/customerinfo',isset($data) ? $data : NULL);

}


public function changepassword(){
User::logged_in();	
$this->load->view('account/changepassword',isset($data) ? $data : NULL);

}



public function bethistory(){
User::logged_in();	


$this->load->view('account/bethistory',isset($data) ? $data : NULL);

}

public function deposit(){
User::logged_in();	
$data["odeme_yontemleri"]=Accounts::odeme_yontemleri();

$this->load->view('account/deposit',isset($data) ? $data : NULL);

}

public function deposit2(){
User::logged_in();	
$data["odeme_yontemleri"]=Accounts::odeme_yontemleri();
$data["odeme_yontemleri_qr"]=Accounts::qr_odeme_yontemleri();

$this->load->view('account/qr',isset($data) ? $data : NULL);

}

public function financehistory(){
User::logged_in();	
$this->load->view('account/financehistory',isset($data) ? $data : NULL);

}

public function bonushistory(){
User::logged_in();	
$this->load->view('account/bonushistory',isset($data) ? $data : NULL);

}


public function withdraw(){
User::logged_in();	
$data["cekim_yontemleri"]=Accounts::para_cekme_yontemleri();

$this->load->view('account/withdraw',isset($data) ? $data : NULL);

}


public function transfer(){
User::logged_in();	
$this->load->view('account/transfer',isset($data) ? $data : NULL);

}

public function messages(){
	User::logged_in();	
$data["mesajlar"]=Accounts::get_messages();
$this->load->view('account/messages',isset($data) ? $data : NULL);
}

public function delmessage($mesaj_id){
User::logged_in();		
	header('Content-Type: application/json');
$sonuc=Accounts::delete_message($mesaj_id);
$oldu["extraMessage"]	="";
$oldu["insertedId"]	="";
if($sonuc){
$oldu["success"]	=true;
$oldu["message"]	="Mesajınız silinmiştir.";
}else{
$oldu["success"]	=false;
$oldu["message"]	="Mesaj silinirken hata oluştu.";	
}
echo json_encode($oldu);
//$this->load->view('account/messages',isset($data) ? $data : NULL);
}


public function bethistorysearch(){
User::logged_in();	
$where["user_id"]=User::get_id();

if($_POST && isset($_POST["udate1"])){
$where["date(tarih)>="]=date("Y-m-d",strtotime($_POST["udate1"]));
}

if($_POST && isset($_POST["udate2"])){
$where["date(tarih)<="]=date("Y-m-d",strtotime($_POST["udate2"]));
}

if($_POST && isset($_POST["ustatus"]) && strlen($_POST["ustatus"])){
$where["durum"]=$_POST["ustatus"];
}
$sonuc=$this->db->Where($where)->Select("*")->get('kupon')->result();
$data["kuponlar"]=$sonuc;
//print_r($sonuc);
$this->load->view('account/inc/bethistorysearch',isset($data) ? $data : NULL);	
}


public function bethistorydetail($kupon_id){
User::logged_in();	
$where["user_id"]=User::get_id();
$where["Id"]=$kupon_id;
$sonuc=$this->db->Where($where)->Select("*")->get('kupon')->row();
$data["kupon_detay"]=$sonuc;

$where=array();
$where["user_id"]=User::get_id();
$where["kupon_id"]=$kupon_id;
$sonuc=$this->db->Where($where)->Select("*")->get('kupon_mac')->result();
$data["maclar"]=$sonuc;


$this->load->view('account/inc/bethistorydetail',isset($data) ? $data : NULL);	
}

public function financehistorysearch(){
User::logged_in();	
$data["islem_turleri"]=$this->db->Select("*")->order_by("islem_turu","ASC")->get('log_islem_turleri')->result();

$where["log.userid"]=User::get_id();
if($_POST && isset($_POST["udate1"])){
$where["date(log.tarih)>="]=date("Y-m-d",strtotime($_POST["udate1"]));
}

if($_POST && isset($_POST["udate2"])){
$where["date(log.tarih)<="]=date("Y-m-d",strtotime($_POST["udate2"]));
}


if($_POST && isset($_POST["transactiontype"]) && strlen($_POST["transactiontype"])){
$where["log.tur"]=$_POST["transactiontype"];
}

if($_POST && isset($_POST["ustatus"]) && strlen($_POST["ustatus"])){
$where["log.durum"]=$_POST["ustatus"];
}

$this->db->join('log_islem_turleri','log_islem_turleri.Id = log.tur');
$sonuc=$this->db->Where($where)->Select("log.*,log_islem_turleri.islem_turu")->get('log')->result();
$data["islemler"]=$sonuc;
//print_r($sonuc);
$this->load->view('account/inc/financehistorysearch',isset($data) ? $data : NULL);	
}

public function financehistorydetail($islem_id){
User::logged_in();	
$where["log.userid"]=User::get_id();
$where["log.id"]=$islem_id;
$this->db->join('log_islem_turleri','log_islem_turleri.Id = log.tur');
$sonuc=$this->db->Where($where)->Select("log.*,log_islem_turleri.islem_turu")->get('log')->row();
$data["islemler"]=$sonuc;
//print_r($sonuc);

$this->load->view('account/inc/financehistorydetail',isset($data) ? $data : NULL);	
}


public function withdrawpending(){
User::logged_in();	
$bekleyen_depozitler=$data["bekleyen_depozitler"]=Accounts::get_withdrawpending();

$this->load->view('account/inc/withdrawpending',isset($data) ? $data : NULL);	
}


public function dowithdraw(){
	User::logged_in();	
header('Content-Type: application/json');
$sonuc="";


$oldu["extraMessage"]	="";
$oldu["insertedId"]	="";


$kisi_bilgileri=User::view_user(User::get_id());

if($kisi_bilgileri->bakiye<str_replace(",",".",$_POST["wamount"])){

$oldu["success"]	=false;
$oldu["message"]	="Bakiyeniz Yeterli değil.";	
echo json_encode($oldu);
}else{
if($_POST["method"]=="havale"){
$sonuc=Accounts::withdraw_havale($_POST);
}elseif($_POST["method"]=="ptthavalewithdraw"){
$sonuc=Accounts::withdraw_ptthavale($_POST);	
}




if($sonuc){
$oldu["success"]	=true;
$oldu["message"]	="Para çekme talebiniz isleme alinmistir.";
}else{
$oldu["success"]	=false;
$oldu["message"]	="Para çekme işleminde hata. Lütfen daha sonra tekrar deneyiniz.";	
}
echo json_encode($oldu);

}
}


public function dodeposit(){
	User::logged_in();	
header('Content-Type: application/json');
$sonuc="";

if($_POST["method"]=="havale"){
$sonuc=Accounts::payment_havale($_POST);
}elseif($_POST["method"]=="ptthavale"){
$sonuc=Accounts::payment_ptthavale($_POST);	
}elseif($_POST["method"]=="cepbank"){
$sonuc=Accounts::payment_cepbank($_POST);	
}elseif($_POST["method"]=="FormVakifCep"){
$sonuc=Accounts::payment_FormVakifCep($_POST);	
}elseif($_POST["method"]=="FormFinansCep"){
$sonuc=Accounts::payment_FormFinansCep($_POST);	
}elseif($_POST["method"]=="iscep"){
$sonuc=Accounts::payment_iscep($_POST);	
}elseif($_POST["method"]=="akbank"){
$sonuc=Accounts::payment_akbank($_POST);	
}elseif($_POST["method"]=="yapikredi"){
$sonuc=Accounts::payment_yapikredi($_POST);	
}elseif($_POST["method"]=="denizbank"){
$sonuc=Accounts::payment_denizbank($_POST);	
}elseif($_POST["method"]=="ingbank"){
$sonuc=Accounts::payment_ingbank($_POST);	
}elseif($_POST["method"]=="pttcep"){
$sonuc=Accounts::payment_pttcep($_POST);	
}elseif($_POST["method"]=="sekerbankcepbank"){
$sonuc=Accounts::payment_sekerbankcepbank($_POST);	
}elseif($_POST["method"]=="tepcepbank"){
$sonuc=Accounts::payment_tepcepbank($_POST);	
}



$oldu["extraMessage"]	="";
$oldu["insertedId"]	="";

if($sonuc){
$oldu["success"]	=true;
$oldu["message"]	="Para yatirma talebiniz isleme alinmistir.";
}else{
$oldu["success"]	=false;
$oldu["message"]	="Para yatirma işleminde hata. Lütfen daha sonra tekrar deneyiniz.";	
}
echo json_encode($oldu);
}


public function depositpending(){
User::logged_in();	
$bekleyen_depozitler=$data["bekleyen_depozitler"]=Accounts::get_depositpending();

$this->load->view('account/inc/depositpending',isset($data) ? $data : NULL);	
}

public function canceldepositpending($id){
User::logged_in();	
$data["bekleyen_depozitler"]=Accounts::canceldepositpending($id);

//$this->load->view('account/inc/depositpending',isset($data) ? $data : NULL);	
}


public function cancelwithdrawpending($id){
User::logged_in();	
$data["bekleyen_depozitler"]=Accounts::cancelwithdrawpending($id);

//$this->load->view('account/inc/depositpending',isset($data) ? $data : NULL);	
}

public function dochangepassword(){
User::logged_in();		
	header('Content-Type: application/json');
//print_r($_POST);
if($_POST){
$sonuc=0;

	if (!$this->tank_auth->is_logged_in()) {								// not logged in or not activated
			redirect('/');

		} else {
			$this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean|min_length['.$this->config->item('password_min_length', 'tank_auth').']|max_length['.$this->config->item('password_max_length', 'tank_auth').']|alpha_dash');
			$this->form_validation->set_rules('confirm_new_password', 'Confirm new Password', 'trim|required|xss_clean|matches[new_password]');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if ($this->tank_auth->change_password(
						$this->form_validation->set_value('old_password'),
						$this->form_validation->set_value('new_password'))) {	// success
		//			$this->_show_message($this->lang->line('auth_message_password_changed'));
$sonuc=1;
				} else {

$sonuc=0;// fail
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
		//	$this->load->view('auth/change_password_form', $data);
		}




$oldu["extraMessage"]	="";
$oldu["insertedId"]	="";
if($sonuc){
$oldu["success"]	=true;
$oldu["message"]	="Şifreniz başarıyla değişti.";
}else{
$oldu["success"]	=false;
$oldu["message"]	="Şifre Değiştirme Hatası.";	
}
echo json_encode($oldu);

}
}


public function doregister(){
header('Content-Type: application/json');

if (User::is_loggedin()) {
redirect("/","refresh");
}	

$data = $this->tank_auth->create_user2($_POST);
if($data["hata"]==0){
$oldu["success"]	=true;
$oldu["message"]="";
}else{
$oldu["success"]	=false;
$oldu["message"]=$data["hata_aciklama"];
}
echo json_encode($oldu);


}

}
