<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Accounts extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }


    static function odeme_yontemleri()
    {
        $ci = &get_instance();
       return self::$db->Where(array("onay"=>1))->Select("*")->get('para_yatirma_yontemleri')->result();
    }

    static function qr_odeme_yontemleri()
    {
        $ci = &get_instance();
       return self::$db->Where(array("onay"=>1))->Select("*")->get('qr_para_yatirma_yontemleri')->result();
    }
    static function para_cekme_yontemleri()
    {
        $ci = &get_instance();
       return self::$db->Where(array("onay"=>1))->Select("*")->get('para_cekme_yontemleri')->result();
    }



    // Get logged in user ID
    static function get_messages()
    {
        $ci = &get_instance();
       return self::$db->Where(array("user_id"=>User::get_id()))->Select("*")->get('user_messages')->result();
    }

static function delete_message($mesaj_id){

$where=array("Id"=>$mesaj_id,
            "user_id"=>User::get_id());    
return self::$db->delete("user_messages",$where);
}


static function withdraw_havale($post){

$kisi_bilgileri=User::view_user(User::get_id());

$yeni_bakiye=$kisi_bilgileri->bakiye-str_replace(",",".",$post["wamount"]);

self::$db->set('bakiye', $yeni_bakiye);
self::$db->where('id', User::get_id());
self::$db->update("users");


$aciklama="";
$aciklama.="Banka : ".$post["wbanka"]."<br><br>";
$aciklama.="Alıcı : ".$post["wname1"]."<br><br>";
$aciklama.="Şube Kodu :".$post["wsube"]."<br><br>";
$aciklama.="Hesap Numarası : ".$post["whesap"]."<br><br>";
$aciklama.="IBAN : ".$post["wiban"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>6,
            "islemad"=>$post["wbanka"]." Para Çekme",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$post["wcustomernote"]." - ".$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$aciklama="";
$aciklama.="Banka : ".$post["wbanka"]."<br><br>";
$aciklama.="Alıcı : ".$post["wname1"]."<br><br>";
$aciklama.="Şube Kodu :".$post["wsube"]."<br><br>";
$aciklama.="Hesap Numarası : ".$post["whesap"]."<br><br>";
$aciklama.="IBAN : ".$post["wiban"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>$post["wbanka"],
            "tur"=>"Banka Havalesi ile Para Çekme",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
           
            "not"=>$post["wcustomernote"],
            "log_id"=>$log_id);

return self::$db->insert('para_cek',$data);
}

static function withdraw_ptthavale($post){

$kisi_bilgileri=User::view_user(User::get_id());

$yeni_bakiye=$kisi_bilgileri->bakiye-str_replace(",",".",$post["wamount"]);

self::$db->set('bakiye', $yeni_bakiye);
self::$db->where('id', User::get_id());
self::$db->update("users");


$aciklama="";
$aciklama.="Banka : ".$post["wbanka"]."<br><br>";
$aciklama.="Hesap Numarası : ".$post["waccountno"]."<br><br>";


$data=array("userid"=>User::get_id(),
            "tur"=>25,
            "islemad"=>$post["wbanka"]." Para Çekme",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$post["wcustomernote"]." - ".$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$aciklama="";
$aciklama.="Banka : ".$post["wbanka"]."<br><br>";
$aciklama.="Hesap Numarası : ".$post["waccountno"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>$post["wbanka"],
            "tur"=>"Banka Havalesi ile Para Çekme",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
           
            "not"=>$post["wcustomernote"],
            "log_id"=>$log_id);

return self::$db->insert('para_cek',$data);
}


static function payment_havale($post){

$aciklama="";
$aciklama.="Banka : ".$post["wbanka"]."<br><br>";
$aciklama.="Gönderen : ".$post["wname1"]."<br><br>";
$aciklama.="İşlem Saati :".$post["whavalehour"].":".$post["whavaleminute"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["whavaletype"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>5,
            "islemad"=>$post["wbanka"]." Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$post["wcustomernote"]." - ".$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$aciklama="";
$aciklama.="Gönderen : ".$post["wname1"]."<br><br>";
$aciklama.="İşlem Saati :".$post["whavalehour"].":".$post["whavaleminute"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["whavaletype"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>$post["wbanka"],
            "tur"=>"Banka Havalesi ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "not"=>$post["wcustomernote"],
            "log_id"=>$log_id);

return self::$db->insert('para_yatir',$data);
}


static function payment_ptthavale($post){

    $aciklama="";

$aciklama.="Gönderen : ".$post["waccountowner"]."<br><br>";
$aciklama.="İşlem Saati :".$post["whavalehour"].":".$post["whavaleminute"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["wpttwhavaletype"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>24,
            "islemad"=>"PTT Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$post["wcustomernote"]." - ".$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();


$aciklama="";
$aciklama.="Gönderen : ".$post["waccountowner"]."<br><br>";
$aciklama.="İşlem Saati :".$post["whavalehour"].":".$post["whavaleminute"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["wpttwhavaletype"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>"PTT",
            "tur"=>"PTT Havalesi ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "not"=>$post["wcustomernote"],
            "log_id"=>$log_id);

return self::$db->insert('para_yatir',$data);
}

static function payment_cepbank($post){

        $aciklama="";

$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["wtransfermethod"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>31,
            "islemad"=>"Garanti Bankası Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();


$aciklama="";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";
$aciklama.="Gönderim Türü : ".$post["wtransfermethod"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>"Garanti",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}


static function payment_FormVakifCep($post){

        $aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>28,
            "islemad"=>"Vakıfbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();


$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";


$data=array("user_id"=>User::get_id(),
            "banka"=>"Vakıfbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}

static function payment_FormFinansCep($post){
$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";


$data=array("userid"=>User::get_id(),
            "tur"=>19,
            "islemad"=>"Finansbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"Finansbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}



static function payment_iscep($post){
$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Doğum Tarihi : ".$post["wdob"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wreferenceno"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>11,
            "islemad"=>"İşbankası Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"İş Bankası",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}


static function payment_akbank($post){
$aciklama="";
$aciklama.="Gönderici TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wreferenceno"]."<br><br>";


$data=array("userid"=>User::get_id(),
            "tur"=>4,
            "islemad"=>"Akbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();


$data=array("user_id"=>User::get_id(),
            "banka"=>"Akbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}

static function payment_yapikredi($post){
$aciklama="";
$aciklama.="Gönderici TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>14,
            "islemad"=>"Yapıkredi Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"Yapıkredi",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
             "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}


static function payment_denizbank($post){
$aciklama="";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>18,
            "islemad"=>"Denizbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();



$data=array("user_id"=>User::get_id(),
            "banka"=>"Denizbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}

static function payment_ingbank($post){
$aciklama="";
$aciklama.="Gönderici TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Gönderen Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";


$data=array("userid"=>User::get_id(),
            "tur"=>30,
            "islemad"=>"INGbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"Ing Bank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}


static function payment_pttcep($post){
$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wreceiverphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";



$data=array("userid"=>User::get_id(),
            "tur"=>23,
            "islemad"=>"PTT Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"PTT Cepbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}


static function payment_sekerbankcepbank($post){
$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wtcid"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wreceiverphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";


$data=array("userid"=>User::get_id(),
            "tur"=>26,
            "islemad"=>"Şekerbank Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();

$data=array("user_id"=>User::get_id(),
            "banka"=>"Şekerbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}

static function payment_tepcepbank($post){
$aciklama="";
$aciklama.="Alıcı TC. Kimlik No : ".$post["wreceiveridentifyno"]."<br><br>";
$aciklama.="Alıcı Telefon : ".$post["wrecipientphone"]."<br><br>";
$aciklama.="Şifre / Referans : ".$post["wpassword"]."<br><br>";

$aciklama.="Gönderici Telefon : ".$post["wsenderphone"]."<br><br>";
$aciklama.="Gönderici TC. Kimlik : ".$post["wtcid"]."<br><br>";

$data=array("userid"=>User::get_id(),
            "tur"=>27,
            "islemad"=>"Teb Cepbank Para Yatırma",
            "tutar"=>str_replace(",",".",$post["wamount"]),
            "musteri_notu"=>$aciklama);

self::$db->insert('log',$data);
$log_id=self::$db->insert_id();


$data=array("user_id"=>User::get_id(),
            "banka"=>"TEB Cepbank",
            "tur"=>"Cepbank ile Para Yatırma",
            "miktar"=>str_replace(",",".",$post["wamount"]),
            "aciklama"=>$aciklama,
            "bonus"=>$post["wbonusid"],
            "log_id"=>$log_id
            );

return self::$db->insert('para_yatir',$data);
}



    static function get_depositpending()
    {
        $ci = &get_instance();
return self::$db->Where(array("user_id"=>User::get_id(),"durum"=>0))->Order_by("islem_tarih", "DESC")->Select("*")->get('para_yatir')->result();
    }



    static function get_withdrawpending()
    {
        $ci = &get_instance();
return self::$db->Where(array("user_id"=>User::get_id(),"durum"=>0))->Order_by("islem_tarih", "DESC")->Select("*")->get('para_cek')->result();
    }


static function canceldepositpending($id){

$bul=self::$db->Where(array("user_id"=>User::get_id(),"Id"=>$id,"durum"=>0))->Select("log_id")->get('para_yatir')->row();

if(count($bul)>0){
$where=array("id"=>$bul->log_id,
            "userid"=>User::get_id(),
            "durum"=>0);    
self::$db->delete("log",$where);
}
$where=array("Id"=>$id,
            "user_id"=>User::get_id(),
            "durum"=>0);    
return self::$db->delete("para_yatir",$where);
}


static function cancelwithdrawpending($id){

$bul=self::$db->Where(array("user_id"=>User::get_id(),"Id"=>$id,"durum"=>0))->Select("log_id,miktar")->get('para_cek')->row();

if(count($bul)>0){

$kisi_bilgileri=User::view_user(User::get_id());

$yeni_bakiye=$kisi_bilgileri->bakiye+str_replace(",",".",$bul->miktar);

self::$db->set('bakiye', $yeni_bakiye);
self::$db->where('id', User::get_id());
self::$db->update("users");


$where=array("id"=>$bul->log_id,
            "userid"=>User::get_id(),
            "durum"=>0);    
self::$db->delete("log",$where);
}
$where=array("Id"=>$id,
            "user_id"=>User::get_id(),
            "durum"=>0);    
return self::$db->delete("para_cek",$where);
}


static function kupon_kaydet($veri){
//print_r($veri);

foreach ($veri as $kupon) {
$kisi_bilgileri=User::login_info(User::get_id());
//echo $kisi_bilgileri->bakiye;
//echo "<br>";
if($kisi_bilgileri->bakiye>=str_replace(",",".",$kupon["miktar"])){
$data=array("user_id"=>$kupon["user_id"],
            "miktar"=>str_replace(",",".",$kupon["miktar"]),
            "oran"=>str_replace(",",".",$kupon["oran"]),
            "toplam"=>$kupon["toplam"],
            "ip"=>$kupon["ip"],
            "zaman"=>$kupon["zaman"]);

self::$db->insert('kupon', $data);
$kupon_id=self::$db->insert_id();




$data=array("userid"=>User::get_id(),
            "islemad"=>$kupon_id." Nolu Bahis Yapıldı",
            "tutar"=>str_replace(",",".",$kupon["miktar"]),
            "oncekibakiye"=>$kisi_bilgileri->bakiye,
            "durum"=>1,
            "tur"=>1,
            "sonrakibakiye"=>($kisi_bilgileri->bakiye-str_replace(",",".",$kupon["miktar"])));
self::$db->insert('log', $data);

$kalan_bakiye=($kisi_bilgileri->bakiye-str_replace(",",".",$kupon["miktar"]));
self::$db->set('bakiye', $kalan_bakiye);
self::$db->where('id', User::get_id());
self::$db->update("users");



foreach ($kupon["maclar"] as $maclar) {
$data=array("kupon_id"=>$kupon_id,
            "tarih"=>date("Y-m-d H:i:s",strtotime($maclar["tarih"])),
            "user_id"=>User::get_id(),
            "mac_id"=>$maclar["mac_id"],
            "oran_id"=>$maclar["oran_id"],
            "canli"=>$maclar["canlimi"],
            "mac_turu"=>$maclar["mac_turu"],
            "oran_tur"=>$maclar["oran_tur"],
            "secim"=>$maclar["secim"],
            "oran"=>str_replace(",",".",$maclar["oran"]),
            "dakika"=>$maclar["dakika"],
            "skor"=>$maclar["skor"],
            "periyodlar"=>$maclar["periyodlar"],
            "ev_sahibi"=>$maclar["ev_sahibi"],
            "misafir"=>$maclar["misafir"],
);

self::$db->insert('kupon_mac', $data);
}
}
}

/*
self::$db->insert('invoices', $data);
return self::$db->insert_id();*/   
return false; 
}

   static function get_last_koupon($zaman)
    {
        $ci = &get_instance();
       return self::$db->Where(array("user_id"=>User::get_id(),"zaman"=>$zaman))->Select("*")->get('kupon')->result();
    }

   static function get_kupon_mac($kupon_id)
    {
        $ci = &get_instance();
       return self::$db->Where(array("user_id"=>User::get_id(),"kupon_id"=>$kupon_id))->Select("*")->get('kupon_mac')->result();
    }


   static function mac_tarihi_bul($mac_id)
    {
        $ci = &get_instance();
       return self::$db->Where(array("mac_id"=>$mac_id))->Select("tarih")->get('bulten')->row();
    }

}

/* End of file model.php */
