<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Freelancer Office
 *
 * Web based project and invoicing management system available on codecanyon
 *
 * @package     Freelancer Office
 * @author      William Mandai
 * @copyright   Copyright (c) 2014 - 2016 Gitbench,
 * @license     http://codecanyon.net/wiki/support/legal-terms/licensing-terms/
 * @link        http://codecanyon.net/item/freelancer-office/8870728
 * @link        https://gitbench.com
 */

class Betradar_model extends CI_Model
{

    private static $db;

    function __construct(){
        parent::__construct();
        self::$db = &get_instance()->db;
    }


    static function sonucsuz_maclar()
    {
        $ci = &get_instance();

$tarih=$tarih=date('Y-m-d H:i:s', mktime(date('H')-2, date('i'), date('s'), date('m'), date('d'), date('Y')));

return self::$db->where(array('bulten.tarih<'=>$tarih,'bulten.durum<'=>60, 'betradarid>'=>0))->group_by("Id")->Select("bulten.Id,bulten.tarih,bulten.mac_id,bulten.ev_sahibi,bulten.misafir,bulten.ulke,bulten.lig,bulten.bot,bulten.betradarid")->get('bulten')->result();



    }


static function ulke_isle($country_id,$country,$sporttype){

$c = self::$db->where(array("country_id"=>$country_id,"country"=>$country,"sporttype"=>$sporttype))->select("country_id")->get('ulkeler')->row();

 if(count($c)>0){
return $c->country_id;    
 }else{
$data=array("country_id"=>$country_id,
            "country"=>$country,
            "sporttype"=>$sporttype);
return self::$db->insert('ulkeler',$data);

return 0;        
 }
        
}

static function lig_isle($country_id,$lig_id,$lig,$sporttype){

$c = self::$db->where(array("country"=>$country_id,"lig_id"=>$lig_id,"sporttype"=>$sporttype))->select("lig_id")->get('ligler')->row();

 if(count($c)>0){
return $c->lig_id;    
 }else{
$data=array("lig_id"=>$lig_id,
            "lig"=>$lig,
            "country"=>$country_id,
            "sporttype"=>$sporttype);
return self::$db->insert('ligler',$data);

return 0;        
 }
        
}

    static function bulten($where=array(),$limit = NULL,$start = NULL)
    {
        $ci = &get_instance();
$tarih=date("Y-m-d H:i:s");
return self::$db->where($where)->order_by("tarih","DESC")->group_by("mac_id")->Select("*")->get('bulten',$limit,$start)->result();
    }

static function betradaradres(){
return self::$db->Select("betradar_sitesi")->get('ayarlar')->row();    
}
static function mac_turleri(){
return self::$db->where(array('betradar_id>'=>0))->Select("*")->get('mac_turleri')->result();
}

static function Ulkeleri($turru)
{
    
$adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'vary:Accept-Encoding',
    'x-requested-with:XMLHttpRequest',
    
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/pre.menu");
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'hour=86400&type=category&sportid='.$turru);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);
}


static function Maclar($ulke)
{
    $adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.prematch");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'hour=86400&search=null&category='.$ulke.'&tournament=all');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);
}


static function Orancek($mac_id)
{
    $adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.prematchdetail");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'DataSource=1&MatchID='.$mac_id);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);
}

 static function tarihi($t)
{
$tbu = str_replace(" ",".2017 ",$t);
$tbu=$tbu.":00";
//$tbu=date("Y-m-d H:i:s",$tbu);
return $tbu;
}



static function nokta($t)
{
$tbu = str_replace(",",".",$t);
return $tbu;
}




static function Oranlar($mac)
{
    $adres=    self::betradaradres()->betradar_sitesi;
$conc = strlen("MatchID=$mac&DataSource=1");
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'content-length:'.$conc,
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.prematchdetail");
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'MatchID='.$mac.'&DataSource=1');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);
}


static function CanliOranlar($mac)
{


        $adres=    self::betradaradres()->betradar_sitesi;
$conc = strlen("MatchID=$mac&DataSource=1");
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'content-length:'.$conc,
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.livematchdetail");
curl_setopt($ch, CURLOPT_REFERER,$adres."live");
curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_POSTFIELDS,'MatchID='.$mac.'&DataSource=1');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);
return $cik;
curl_close ($ch);

}

static function canlilist()
{
    $adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
    'device:d'
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.livematch");
curl_setopt($ch, CURLOPT_REFERER,$adres."live");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//curl_setopt($ch, CURLOPT_POSTFIELDS,'hour=86400&search=null&category='.$ulke.'&tournament=all');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);


return $cik;
curl_close ($ch);
}


static function canlilistgelecek()
{
    $adres=    self::betradaradres()->betradar_sitesi;
$ch = curl_init();
$headers = array(
    'user-agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.111 Safari/537.36',
    'x-requested-with:XMLHttpRequest',
    'vary:Accept-Encoding',
    'x-powered-by:PHP/5.6.12',
    'device:d'
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_URL,$adres."services/list.livematchnext");
curl_setopt($ch, CURLOPT_REFERER,$adres."live");
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//curl_setopt($ch, CURLOPT_POST, 1);
if(config_item("proxyip")!=""){
curl_setopt($ch, CURLOPT_PROXY, config_item("proxyip"));
if(config_item("proxysifre")!="" && config_item("proxykull")!=""){
curl_setopt($ch, CURLOPT_PROXYUSERPWD, config_item("proxykull").":".config_item("proxysifre"));   
}
}
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//curl_setopt($ch, CURLOPT_POSTFIELDS,'hour=86400&search=null&category='.$ulke.'&tournament=all');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$cik = curl_exec ($ch);


return $cik;
curl_close ($ch);
}

static function macabak($betradar,$tur,$canlimi){

$c = self::$db->where(array("canli"=>$canlimi,"mac_id"=>$betradar,"tur"=>$tur))->select("Id")->get('bulten')->row();

 if(count($c)>0){
    
return $c->Id;    
 }else{
return 0;        
 }
        
}


static function tur_bul($tur_id){

$c = self::$db->where(array("betradar_id"=>$tur_id))->select("tur_id")->get('mac_turleri')->row();

 if(count($c)>0){
return $c->tur_id;    
 }else{
return 0;        
 }
        
}

static function mac_ekle($data=array()){

return self::$db->insert('bulten',$data);

}

static function mac_guncelle($data=array(),$where=array()){
return self::$db->set($data)->where($where)->update('bulten');
}

static function kupon_mac_guncelle($data=array(),$where=array()){
return self::$db->set($data)->where($where)->update('kupon_mac');
}

    static function canli_bulten()
    {
        $ci = &get_instance();
$tarih=date("Y-m-d");
self::$db->join('mac_turleri','mac_turleri.tur_id = bulten.tur');
return self::$db->where(array('bulten.canli'=>1,'bot'=>'betradar','oynuyormu'=>1))->Select("bulten.Id,bulten.tarih,bulten.mac_id,bulten.ev_sahibi,bulten.misafir,bulten.ulke,bulten.lig,bulten.dakika,bulten.ceyrek,bulten.betradarid,bulten.ms,bulten.toplam_oran,mac_turleri.tur,mac_turleri.css_id")->get('bulten')->result();
    }


     static function sonuclar()
    {
        $ci = &get_instance();
$tarih=date("Y-m-d");
self::$db->join('mac_turleri','mac_turleri.tur_id = bulten.tur');
self::$db->join('mac_durumlari','mac_durumlari.durum_id = bulten.durum');
return self::$db->where(array('bulten.durum>='=>70,'bot'=>'betradar'))->Select("bulten.Id,bulten.tarih,bulten.mac_id,bulten.ev_sahibi,bulten.misafir,bulten.ulke,bulten.lig,bulten.dakika,bulten.ms,bulten.iy,mac_turleri.tur,mac_turleri.css_id,mac_durumlari.durum AS durum_str")->get('bulten')->result();
    }



static function mac_durumu_gir($durum_id,$durum){

$c = self::$db->where(array("durum_id"=>$durum_id))->select("durum_id")->get('mac_durumlari')->row();

 if(count($c)>0){
return $c->durum_id;    
 }else{
$data=array("durum_id"=>$durum_id,
            "durum"=>$durum);
return self::$db->insert('mac_durumlari',$data);

return 0;        
 }
        
}


static function oran_turu_bak($tur,$SportID){
$c = self::$db->where(array("bahis_adi"=>$tur,'mac_turu'=>$SportID))->select("Id")->get('bahis_turleri')->row();
if(count($c)>0){
return $c->Id;    
 }else{
return 0;        
 }
      
}



static function oran_tur_ekle($tur,$SportID,$canlimi){

$c = self::$db->where(array("bahis_adi"=>$tur,'mac_turu'=>$SportID,'canli'=>$canlimi))->select("Id")->get('bahis_turleri')->row();

 if(count($c)>0){
return $c->Id;    
 }else{
$data=array("bahis_adi"=>$tur,
    "mac_turu"=>$SportID,
    'canli'=>$canlimi
            );
return self::$db->insert('bahis_turleri',$data);

return 0;        
 }
        
}

static function oran_tur_secim_ekle($bahis_adi,$SportID,$canlimi,$secim){

$c = self::$db->where(array("bahis_adi"=>$bahis_adi,'mac_turu'=>$SportID,'canli'=>$canlimi,"secim"=>$secim))->select("Id")->get('bahis_turleri_secimler')->row();

 if(count($c)>0){
return $c->Id;    
 }else{
$data=array("bahis_adi"=>$bahis_adi,
    "mac_turu"=>$SportID,
    'canli'=>$canlimi,
    'secim'=>$secim
            );
return self::$db->insert('bahis_turleri_secimler',$data);

return 0;        
 }
        
}


static function gol_ekle($data){
return self::$db->insert('maclar_goller',$data);
}

static function kart_ekle($data){
return self::$db->insert('maclar_kartlar',$data);
}

static function korner_ekle($data){
return self::$db->insert('maclar_kornerler',$data);
}

static function kart_sil($mac_id){
return self::$db->where("mac_id",$mac_id)->delete('maclar_kartlar');
}

static function korner_sil($mac_id){
return self::$db->where("mac_id",$mac_id)->delete('maclar_kornerler');
}
static function gol_sil($mac_id){
return self::$db->where("mac_id",$mac_id)->delete('maclar_goller');
}


static function durum_bittimi($durum){
$c = self::$db->where(array("durum_id"=>$durum))->select("bittimi")->get('mac_durumlari')->row();
if(count($c)>0){
return $c->bittimi;    
 }else{
return 0;        
 }
      
}


}

/* End of file model.php */
